/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectAdviceInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.parser.xml.ExceptionInnerNodeletAdder;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.TextStyler;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class AspectNodeletAdder
implements NodeletAdder {
    AspectNodeletAdder() {
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        AspectAdviceInnerNodeletAdder aspectAdviceInnerNodeletAdder = nodeParser.getAspectAdviceInnerNodeletAdder();
        ExceptionInnerNodeletAdder exceptionInnerNodeletAdder = nodeParser.getExceptionInnerNodeletAdder();
        ContextRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/aspect");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            String order = StringUtils.emptyToNull((String)attrs.get("order"));
            Boolean isolated = BooleanUtils.toNullableBooleanObject((String)attrs.get("isolated"));
            Boolean disabled = BooleanUtils.toNullableBooleanObject((String)attrs.get("disabled"));
            AspectRule aspectRule = AspectRule.newInstance(id, order, isolated, disabled);
            parser.pushObject(aspectRule);
        });
        parser.addNodeEndlet(text -> {
            AspectRule aspectRule = (AspectRule)parser.popObject();
            assistant.addAspectRule(aspectRule);
        });
        parser.setXpath(xpath + "/aspect/description");
        parser.addNodelet(attrs -> {
            String style = (String)attrs.get("style");
            parser.pushObject(style);
        });
        parser.addNodeEndlet(text -> {
            String style = (String)parser.popObject();
            if (style != null) {
                text = TextStyler.styling(text, style);
            }
            if (StringUtils.hasText(text)) {
                AspectRule aspectRule = (AspectRule)parser.peekObject();
                aspectRule.setDescription(text);
            }
        });
        parser.setXpath(xpath + "/aspect/joinpoint");
        parser.addNodelet(attrs -> {
            String type = StringUtils.emptyToNull((String)attrs.get("type"));
            parser.pushObject(type);
        });
        parser.addNodeEndlet(text -> {
            String type = (String)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            AspectRule.updateJoinpoint(aspectRule, type, text);
        });
        parser.setXpath(xpath + "/aspect/settings");
        parser.addNodelet(attrs -> {
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            SettingsAdviceRule sar = SettingsAdviceRule.newInstance(aspectRule);
            parser.pushObject(sar);
        });
        parser.addNodeEndlet(text -> {
            SettingsAdviceRule sar = (SettingsAdviceRule)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            aspectRule.setSettingsAdviceRule(sar);
        });
        parser.setXpath(xpath + "/aspect/settings/setting");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            SettingsAdviceRule sar = (SettingsAdviceRule)parser.peekObject();
            sar.putSetting(name, value);
            parser.pushObject(name);
        });
        parser.addNodeEndlet(text -> {
            String name = (String)parser.popObject();
            if (text != null) {
                SettingsAdviceRule sar = (SettingsAdviceRule)parser.peekObject();
                sar.putSetting(name, text);
            }
        });
        parser.setXpath(xpath + "/aspect/advice");
        parser.addNodelet(attrs -> {
            String beanIdOrClass = StringUtils.emptyToNull((String)attrs.get("bean"));
            if (beanIdOrClass != null) {
                AspectRule aspectRule = (AspectRule)parser.peekObject();
                aspectRule.setAdviceBeanId(beanIdOrClass);
                assistant.resolveAdviceBeanClass(aspectRule);
            }
        });
        parser.addNodelet(aspectAdviceInnerNodeletAdder);
        parser.setXpath(xpath + "/aspect/exception");
        parser.addNodelet(attrs -> {
            ExceptionRule exceptionRule = new ExceptionRule();
            parser.pushObject(exceptionRule);
        });
        parser.addNodelet(exceptionInnerNodeletAdder);
        parser.addNodeEndlet(text -> {
            ExceptionRule exceptionRule = (ExceptionRule)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            aspectRule.setExceptionRule(exceptionRule);
        });
    }
}

