/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.ActionNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectAdviceInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.AspectranDtdResolver;
import com.aspectran.core.context.rule.parser.xml.BeanNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ChooseWhenNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.EnvironmentNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ExceptionInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ItemNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ResponseInnerNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.ScheduleNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.TemplateNodeletAdder;
import com.aspectran.core.context.rule.parser.xml.TransletNodeletAdder;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.TextStyler;
import com.aspectran.core.util.apon.VariableParameters;
import com.aspectran.core.util.nodelet.NodeletParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;

public class AspectranNodeParser {
    private final ContextRuleAssistant assistant;
    private final ActionNodeletAdder actionNodeletAdder;
    private final AspectAdviceInnerNodeletAdder aspectAdviceInnerNodeletAdder;
    private final AspectNodeletAdder aspectNodeletAdder;
    private final BeanNodeletAdder beanNodeletAdder;
    private final EnvironmentNodeletAdder environmentNodeletAdder;
    private final ExceptionInnerNodeletAdder exceptionInnerNodeletAdder;
    private final ItemNodeletAdder itemNodeletAdder;
    private final ResponseInnerNodeletAdder responseInnerNodeletAdder;
    private final ScheduleNodeletAdder scheduleNodeletAdder;
    private final TemplateNodeletAdder templateNodeletAdder;
    private final TransletNodeletAdder transletNodeletAdder;
    private final ChooseWhenNodeletAdder chooseWhenNodeletAdder;
    private final ChooseWhenNodeletAdder chooseWhenNoResponseNodeletAdder;
    private final NodeletParser parser;

    public AspectranNodeParser(ContextRuleAssistant assistant) {
        this(assistant, true, true);
    }

    public AspectranNodeParser(ContextRuleAssistant assistant, boolean validating, boolean trackingLocation) {
        this.assistant = assistant;
        this.actionNodeletAdder = new ActionNodeletAdder();
        this.aspectAdviceInnerNodeletAdder = new AspectAdviceInnerNodeletAdder();
        this.aspectNodeletAdder = new AspectNodeletAdder();
        this.beanNodeletAdder = new BeanNodeletAdder();
        this.environmentNodeletAdder = new EnvironmentNodeletAdder();
        this.exceptionInnerNodeletAdder = new ExceptionInnerNodeletAdder();
        this.itemNodeletAdder = new ItemNodeletAdder();
        this.responseInnerNodeletAdder = new ResponseInnerNodeletAdder();
        this.scheduleNodeletAdder = new ScheduleNodeletAdder();
        this.templateNodeletAdder = new TemplateNodeletAdder();
        this.transletNodeletAdder = new TransletNodeletAdder();
        this.chooseWhenNodeletAdder = new ChooseWhenNodeletAdder(true);
        this.chooseWhenNoResponseNodeletAdder = new ChooseWhenNodeletAdder(false);
        this.parser = new NodeletParser(this);
        this.parser.setValidating(validating);
        this.parser.setEntityResolver(new AspectranDtdResolver(validating));
        if (trackingLocation) {
            this.parser.trackingLocation();
        }
        this.addDescriptionNodelets();
        this.addSettingsNodelets();
        this.addTypeAliasNodelets();
        this.addEnvironmentNodelets();
        this.addAspectNodelets();
        this.addBeanNodelets();
        this.addScheduleNodelets();
        this.addTemplateNodelets();
        this.addTransletNodelets();
        this.addAppendNodelets();
    }

    public ContextRuleAssistant getAssistant() {
        return this.assistant;
    }

    public ActionNodeletAdder getActionNodeletAdder() {
        return this.actionNodeletAdder;
    }

    public AspectAdviceInnerNodeletAdder getAspectAdviceInnerNodeletAdder() {
        return this.aspectAdviceInnerNodeletAdder;
    }

    public AspectNodeletAdder getAspectNodeletAdder() {
        return this.aspectNodeletAdder;
    }

    public BeanNodeletAdder getBeanNodeletAdder() {
        return this.beanNodeletAdder;
    }

    public EnvironmentNodeletAdder getEnvironmentNodeletAdder() {
        return this.environmentNodeletAdder;
    }

    public ExceptionInnerNodeletAdder getExceptionInnerNodeletAdder() {
        return this.exceptionInnerNodeletAdder;
    }

    public ItemNodeletAdder getItemNodeletAdder() {
        return this.itemNodeletAdder;
    }

    public ResponseInnerNodeletAdder getResponseInnerNodeletAdder() {
        return this.responseInnerNodeletAdder;
    }

    public ScheduleNodeletAdder getScheduleNodeletAdder() {
        return this.scheduleNodeletAdder;
    }

    public TemplateNodeletAdder getTemplateNodeletAdder() {
        return this.templateNodeletAdder;
    }

    public TransletNodeletAdder getTransletNodeletAdder() {
        return this.transletNodeletAdder;
    }

    public ChooseWhenNodeletAdder getChooseWhenNodeletAdder() {
        return this.chooseWhenNodeletAdder;
    }

    public ChooseWhenNodeletAdder getChooseWhenNoResponseNodeletAdder() {
        return this.chooseWhenNoResponseNodeletAdder;
    }

    public void parse(RuleAppender ruleAppender) throws Exception {
        InputStream inputStream = null;
        try {
            ruleAppender.setNodeTracker(this.parser.getNodeTracker());
            inputStream = ruleAppender.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(ruleAppender.getQualifiedName());
            this.parser.parse(inputSource);
        }
        catch (Exception e) {
            throw new Exception("Error parsing aspectran configuration", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addDescriptionNodelets() {
        this.parser.setXpath("/aspectran/description");
        this.parser.addNodelet(attrs -> {
            String style = (String)attrs.get("style");
            this.parser.pushObject(style);
        });
        this.parser.addNodeEndlet(text -> {
            String style = (String)this.parser.popObject();
            if (style != null) {
                text = TextStyler.styling(text, style);
            }
            if (StringUtils.hasText(text)) {
                this.assistant.getAssistantLocal().setDescription(text);
            }
        });
    }

    private void addSettingsNodelets() {
        this.parser.setXpath("/aspectran/settings");
        this.parser.addNodeEndlet(text -> this.assistant.applySettings());
        this.parser.setXpath("/aspectran/settings/setting");
        this.parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            this.assistant.putSetting(name, value);
            this.parser.pushObject(name);
        });
        this.parser.addNodeEndlet(text -> {
            String name = (String)this.parser.popObject();
            if (text != null) {
                this.assistant.putSetting(name, text);
            }
        });
    }

    private void addTypeAliasNodelets() {
        this.parser.setXpath("/aspectran/typeAliases");
        this.parser.addNodeEndlet(text -> {
            if (StringUtils.hasLength(text)) {
                VariableParameters parameters = new VariableParameters(text);
                for (String alias : parameters.getParameterNameSet()) {
                    this.assistant.addTypeAlias(alias, parameters.getString(alias));
                }
            }
        });
        this.parser.setXpath("/aspectran/typeAliases/typeAlias");
        this.parser.addNodelet(attrs -> {
            String alias = (String)attrs.get("alias");
            String type = (String)attrs.get("type");
            this.assistant.addTypeAlias(alias, type);
        });
    }

    private void addEnvironmentNodelets() {
        this.parser.addNodelet("/aspectran", this.getEnvironmentNodeletAdder());
    }

    private void addAspectNodelets() {
        this.parser.addNodelet("/aspectran", this.getAspectNodeletAdder());
    }

    private void addBeanNodelets() {
        this.parser.addNodelet("/aspectran", this.getBeanNodeletAdder());
    }

    private void addScheduleNodelets() {
        this.parser.addNodelet("/aspectran", this.getScheduleNodeletAdder());
    }

    private void addTemplateNodelets() {
        this.parser.addNodelet("/aspectran", this.getTemplateNodeletAdder());
    }

    private void addTransletNodelets() {
        this.parser.addNodelet("/aspectran", this.getTransletNodeletAdder());
    }

    private void addAppendNodelets() {
        this.parser.setXpath("/aspectran/append");
        this.parser.addNodelet(attrs -> {
            String file = (String)attrs.get("file");
            String resource = (String)attrs.get("resource");
            String url = (String)attrs.get("url");
            String format = (String)attrs.get("format");
            String profile = (String)attrs.get("profile");
            RuleAppendHandler appendHandler = this.assistant.getRuleAppendHandler();
            if (appendHandler != null) {
                AppendRule appendRule = AppendRule.newInstance(file, resource, url, format, profile);
                appendHandler.pending(appendRule);
            }
        });
    }
}

