/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class ItemNodeletAdder
implements NodeletAdder {
    ItemNodeletAdder() {
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ContextRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/item");
        parser.addNodelet(attrs -> {
            String type = (String)attrs.get("type");
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            String valueType = (String)attrs.get("valueType");
            String defaultValue = (String)attrs.get("defaultValue");
            Boolean tokenize = BooleanUtils.toNullableBooleanObject((String)attrs.get("tokenize"));
            Boolean mandatory = BooleanUtils.toNullableBooleanObject((String)attrs.get("mandatory"));
            Boolean secret = BooleanUtils.toNullableBooleanObject((String)attrs.get("secret"));
            ItemRule itemRule = ItemRule.newInstance(type, name, valueType, defaultValue, tokenize, mandatory, secret);
            if (value != null && itemRule.getType() == ItemType.SINGLE) {
                itemRule.setValue(value);
            }
            parser.pushObject(itemRule);
        });
        parser.addNodeEndlet(text -> {
            ItemRule itemRule = (ItemRule)parser.popObject();
            ItemRuleMap itemRuleMap = (ItemRuleMap)parser.peekObject();
            if (itemRule.getType() == ItemType.SINGLE && StringUtils.hasText(text)) {
                itemRule.setValue(text);
            }
            assistant.resolveBeanClass(itemRule);
            itemRuleMap.putItemRule(itemRule);
        });
        parser.setXpath(xpath + "/item/value");
        parser.addNodelet(attrs -> {
            ItemRule itemRule = (ItemRule)parser.peekObject();
            String name = (String)attrs.get("name");
            boolean tokenize = BooleanUtils.toBoolean(BooleanUtils.toNullableBooleanObject((String)attrs.get("tokenize")), itemRule.isTokenize());
            parser.pushObject(name);
            parser.pushObject(tokenize);
            parser.pushObject(null);
        });
        parser.setXpath(xpath + "/item/value/call");
        parser.addNodelet(attrs -> {
            String property;
            String attribute;
            String parameter;
            String template;
            String bean = (String)attrs.get("bean");
            Token t = ItemRule.makeReferenceToken(bean, template = (String)attrs.get("template"), parameter = (String)attrs.get("parameter"), attribute = (String)attrs.get("attribute"), property = (String)attrs.get("property"));
            if (t != null) {
                Token[] tokens = new Token[]{t};
                parser.popObject();
                parser.pushObject(tokens);
            }
        });
        parser.setXpath(xpath + "/item/value/null");
        parser.addNodelet(attrs -> {
            parser.popObject();
            parser.pushObject(null);
        });
        parser.setXpath(xpath + "/item/value");
        parser.addNodeEndlet(text -> {
            Token[] tokens = (Token[])parser.popObject();
            boolean tokenize = (Boolean)parser.popObject();
            String name = (String)parser.popObject();
            ItemRule itemRule = (ItemRule)parser.peekObject();
            if (tokens == null && StringUtils.hasText(text)) {
                tokens = TokenParser.makeTokens(text, tokenize);
            }
            if (itemRule.isListableType()) {
                itemRule.addValue(tokens);
            } else if (itemRule.isMappableType()) {
                itemRule.putValue(name, tokens);
            } else {
                itemRule.setValue(tokens);
            }
        });
        parser.setXpath(xpath + "/item/call");
        parser.addNodelet(attrs -> {
            String bean = StringUtils.emptyToNull((String)attrs.get("bean"));
            String template = StringUtils.emptyToNull((String)attrs.get("template"));
            String parameter = StringUtils.emptyToNull((String)attrs.get("parameter"));
            String attribute = StringUtils.emptyToNull((String)attrs.get("attribute"));
            String property = StringUtils.emptyToNull((String)attrs.get("property"));
            ItemRule itemRule = (ItemRule)parser.peekObject();
            Token t = ItemRule.makeReferenceToken(bean, template, parameter, attribute, property);
            if (t != null) {
                Token[] tokens = new Token[]{t};
                if (itemRule.isListableType()) {
                    itemRule.addValue(tokens);
                } else {
                    itemRule.setValue(tokens);
                }
            }
        });
    }
}

