/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.TextStyler;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class ScheduleNodeletAdder
implements NodeletAdder {
    ScheduleNodeletAdder() {
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ContextRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/schedule");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            ScheduleRule scheduleRule = ScheduleRule.newInstance(id);
            parser.pushObject(scheduleRule);
        });
        parser.addNodeEndlet(text -> {
            ScheduleRule scheduleRule = (ScheduleRule)parser.popObject();
            assistant.addScheduleRule(scheduleRule);
        });
        parser.setXpath(xpath + "/schedule/description");
        parser.addNodelet(attrs -> {
            String style = (String)attrs.get("style");
            parser.pushObject(style);
        });
        parser.addNodeEndlet(text -> {
            String style = (String)parser.popObject();
            if (style != null) {
                text = TextStyler.styling(text, style);
            }
            if (StringUtils.hasText(text)) {
                ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
                scheduleRule.setDescription(text);
            }
        });
        parser.setXpath(xpath + "/schedule/scheduler");
        parser.addNodelet(attrs -> {
            String beanIdOrClass = StringUtils.emptyToNull((String)attrs.get("bean"));
            if (beanIdOrClass != null) {
                ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
                scheduleRule.setSchedulerBeanId(beanIdOrClass);
            }
        });
        parser.setXpath(xpath + "/schedule/scheduler/trigger");
        parser.addNodelet(attrs -> {
            String type = StringUtils.emptyToNull((String)attrs.get("type"));
            parser.pushObject(type);
        });
        parser.addNodeEndlet(text -> {
            String type = (String)parser.popObject();
            ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
            ScheduleRule.updateTrigger(scheduleRule, type, text);
        });
        parser.setXpath(xpath + "/schedule/job");
        parser.addNodelet(attrs -> {
            String transletName = StringUtils.emptyToNull((String)attrs.get("translet"));
            Boolean disabled = BooleanUtils.toNullableBooleanObject((String)attrs.get("disabled"));
            ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
            ScheduledJobRule scheduledJobRule = ScheduledJobRule.newInstance(scheduleRule, transletName, disabled);
            scheduleRule.addScheduledJobRule(scheduledJobRule);
        });
    }
}

