/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.type;

import com.aspectran.core.context.rule.type.ContentType;

public enum TransformType {
    NONE("transform/none"),
    XML("transform/xml"),
    XSL("transform/xsl"),
    TEXT("transform/text"),
    JSON("transform/json"),
    APON("transform/apon");

    private final String alias;

    private TransformType(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    public static TransformType resolve(String alias) {
        for (TransformType type : TransformType.values()) {
            if (!type.alias.equals(alias)) continue;
            return type;
        }
        return null;
    }

    public static TransformType resolve(ContentType contentType) {
        if (contentType == ContentType.TEXT_PLAIN) {
            return TEXT;
        }
        if (contentType == ContentType.TEXT_XML) {
            return XML;
        }
        if (contentType == ContentType.TEXT_JSON) {
            return JSON;
        }
        if (contentType == ContentType.TEXT_APON) {
            return APON;
        }
        return null;
    }
}

