/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.InsufficientEnvironmentException;
import com.aspectran.core.context.builder.ActivityContextBuilder;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.builder.HybridActivityContextBuilder;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.service.AbstractServiceController;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceController;
import com.aspectran.core.util.FileLocker;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.ShutdownHooks;
import com.aspectran.core.util.wildcard.PluralWildcardPattern;
import com.aspectran.scheduler.service.QuartzSchedulerService;
import com.aspectran.scheduler.service.SchedulerService;
import java.io.File;
import java.io.IOException;

public abstract class AbstractCoreService
extends AbstractServiceController
implements CoreService {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CoreService rootService;
    private final ApplicationAdapter applicationAdapter;
    private final boolean lateStart;
    private String basePath;
    private AspectranConfig aspectranConfig;
    private ActivityContextBuilder activityContextBuilder;
    private SchedulerService schedulerService;
    private PluralWildcardPattern exposableTransletNamesPattern;
    private ActivityContext activityContext;
    private FileLocker fileLocker;

    public AbstractCoreService(ApplicationAdapter applicationAdapter) {
        super(true);
        if (applicationAdapter == null) {
            throw new IllegalArgumentException("applicationAdapter must not be null");
        }
        this.rootService = null;
        this.applicationAdapter = applicationAdapter;
        this.lateStart = false;
    }

    public AbstractCoreService(CoreService rootService) {
        super(true);
        if (rootService == null) {
            throw new IllegalArgumentException("rootService must not be null");
        }
        if (rootService.getActivityContext() == null) {
            throw new IllegalStateException("Oops! ActivityContext is not yet created");
        }
        rootService.joinDerivedService(this);
        this.lateStart = rootService.getServiceController().isActive();
        this.rootService = rootService;
        this.applicationAdapter = rootService.getApplicationAdapter();
        this.activityContext = rootService.getActivityContext();
        this.aspectranConfig = rootService.getAspectranConfig();
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public boolean isLateStart() {
        return this.lateStart;
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.activityContext;
    }

    public void setActivityContext(ActivityContext activityContext) {
        this.activityContext = activityContext;
    }

    @Override
    public Activity getDefaultActivity() {
        if (this.getActivityContext() == null) {
            throw new IllegalStateException("ActivityContext is not yet created");
        }
        return this.getActivityContext().getDefaultActivity();
    }

    @Override
    public AspectranClassLoader getAspectranClassLoader() {
        if (this.activityContextBuilder == null) {
            throw new IllegalStateException("ActivityContextLoader is not initialized; Call prepare() method first");
        }
        return this.activityContextBuilder.getAspectranClassLoader();
    }

    @Override
    public AspectranConfig getAspectranConfig() {
        return this.aspectranConfig;
    }

    @Override
    public boolean isHardReload() {
        if (this.activityContextBuilder == null) {
            throw new IllegalStateException("ActivityContextLoader is not initialized; Call prepare() method first");
        }
        return this.activityContextBuilder.isHardReload();
    }

    @Override
    public ServiceController getServiceController() {
        return this;
    }

    @Override
    public void joinDerivedService(CoreService coreService) {
        super.joinDerivedService(coreService.getServiceController());
    }

    @Override
    public boolean isDerived() {
        return this.rootService != null;
    }

    protected void prepare(AspectranConfig aspectranConfig) throws AspectranServiceException {
        if (this.activityContext != null) {
            throw new IllegalStateException("ActivityContext has already been loaded");
        }
        try {
            this.aspectranConfig = aspectranConfig;
            ContextConfig contextConfig = aspectranConfig.getContextConfig();
            if (contextConfig != null) {
                boolean singleton;
                String basePath = contextConfig.getBasePath();
                if (basePath != null) {
                    this.setBasePath(basePath);
                }
                if ((singleton = contextConfig.isSingleton()) && !this.checkSingletonLock()) {
                    throw new InsufficientEnvironmentException("Another instance of Aspectran is already running; Only one instance is allowed (context.singleton is set to true)");
                }
            }
            this.activityContextBuilder = new HybridActivityContextBuilder(this);
            this.activityContextBuilder.setBasePath(this.getBasePath());
            this.activityContextBuilder.setContextConfig(contextConfig);
            this.activityContextBuilder.setServiceController(this);
            this.schedulerService = this.createSchedulerService(aspectranConfig.getSchedulerConfig());
        }
        catch (Exception e) {
            throw new AspectranServiceException("Unable to prepare the service", e);
        }
    }

    protected void setExposals(String[] includePatterns, String[] excludePatterns) {
        if (includePatterns != null && includePatterns.length > 0 || excludePatterns != null && excludePatterns.length > 0) {
            this.exposableTransletNamesPattern = new PluralWildcardPattern(includePatterns, excludePatterns, '/');
        }
    }

    protected boolean isExposable(String transletName) {
        return this.exposableTransletNamesPattern == null || this.exposableTransletNamesPattern.matches(transletName);
    }

    protected void loadActivityContext() throws ActivityContextBuilderException {
        if (this.activityContextBuilder == null) {
            throw new IllegalStateException("ActivityContextLoader is not in an instantiated state; First, call the prepare() method");
        }
        if (this.activityContext != null) {
            throw new IllegalStateException("ActivityContext has already been loaded; Must destroy the current ActivityContext before reloading");
        }
        this.activityContextBuilder.build();
    }

    protected void destroyActivityContext() {
        if (this.activityContextBuilder == null) {
            throw new IllegalStateException("ActivityContextBuilder is not in an instantiated state; First, call the prepare() method");
        }
        this.activityContextBuilder.destroy();
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    private SchedulerService createSchedulerService(SchedulerConfig schedulerConfig) {
        if (schedulerConfig == null) {
            return null;
        }
        if (!schedulerConfig.isStartup()) {
            return null;
        }
        int startDelaySeconds = schedulerConfig.getStartDelaySeconds();
        boolean waitOnShutdown = schedulerConfig.isWaitOnShutdown();
        ExposalsConfig exposalsConfig = schedulerConfig.getExposalsConfig();
        if (startDelaySeconds == -1) {
            startDelaySeconds = 5;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Scheduler option 'startDelaySeconds' not specified, defaulting to 5 seconds");
            }
        }
        QuartzSchedulerService schedulerService = new QuartzSchedulerService(this);
        if (waitOnShutdown) {
            schedulerService.setWaitOnShutdown(true);
        }
        schedulerService.setStartDelaySeconds(startDelaySeconds);
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            schedulerService.setExposals(includePatterns, excludePatterns);
        }
        return schedulerService;
    }

    private boolean checkSingletonLock() throws Exception {
        if (this.fileLocker != null) {
            throw new IllegalStateException("Already instantiated a file locker for Singleton lock");
        }
        try {
            String basePath = this.getBasePath();
            if (basePath == null) {
                basePath = SystemUtils.getProperty("java.io.tmpdir");
            }
            if (basePath != null) {
                this.fileLocker = new FileLocker(new File(basePath, ".lock"));
                if (this.fileLocker.lock()) {
                    ShutdownHooks.add(() -> {
                        if (this.fileLocker != null) {
                            try {
                                this.fileLocker.release();
                                this.fileLocker = null;
                            }
                            catch (Exception e) {
                                this.log.warn("Unable to release Singleton lock: " + e);
                            }
                        }
                    });
                    return true;
                }
                return false;
            }
            throw new IllegalArgumentException("Unable to determine the directory where the lock file will be located");
        }
        catch (Exception e) {
            throw new Exception("Unable to acquire Singleton lock", e);
        }
    }

    protected void determineBasePath() {
        try {
            String baseDir = SystemUtils.getProperty("aspectran.basePath");
            if (baseDir != null) {
                File dir = new File(baseDir);
                if (!dir.isDirectory()) {
                    throw new IOException("Make sure it is a valid base directory; aspectran.basePath=" + baseDir);
                }
            } else {
                baseDir = new File("").getCanonicalPath();
            }
            this.setBasePath(baseDir);
        }
        catch (IOException e) {
            throw new AspectranServiceException("Can not verify base directory");
        }
    }
}

