/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.service.ServiceController;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractServiceController
implements ServiceController {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Object lock = new Object();
    private final List<ServiceController> derivedServices;
    private ServiceStateListener serviceStateListener;
    private volatile boolean active;

    public AbstractServiceController(boolean derivable) {
        this.derivedServices = derivable ? new ArrayList<ServiceController>(5) : null;
    }

    @Override
    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setServiceStateListener(ServiceStateListener serviceStateListener) {
        this.serviceStateListener = serviceStateListener;
    }

    protected void joinDerivedService(ServiceController serviceController) {
        if (this.derivedServices == null) {
            throw new UnsupportedOperationException("Derived service control not supported");
        }
        this.derivedServices.add(serviceController);
    }

    protected void clearDerivedService() {
        if (this.derivedServices != null) {
            this.derivedServices.clear();
        }
    }

    protected abstract boolean isDerived();

    protected abstract void doStart() throws Exception;

    protected abstract void doPause() throws Exception;

    protected abstract void doPause(long var1) throws Exception;

    protected abstract void doResume() throws Exception;

    protected abstract void doStop() throws Exception;

    protected Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                throw new IllegalStateException(this.getServiceName() + " is already started");
            }
            if (!this.isDerived()) {
                this.log.info("Starting " + this.getServiceName());
                this.doStart();
                if (this.derivedServices != null) {
                    for (ServiceController serviceController : this.derivedServices) {
                        serviceController.start();
                    }
                }
            }
            this.log.info(this.getServiceName() + " started successfully");
            if (this.serviceStateListener != null) {
                this.serviceStateListener.started();
            }
            this.active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDerived()) {
                if (!this.active) {
                    throw new IllegalStateException(this.getServiceName() + " is not yet started");
                }
                this.log.info("Restarting " + this.getServiceName());
            } else {
                if (this.active) {
                    throw new IllegalStateException(this.getServiceName() + " should never be run separately");
                }
                this.active = true;
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused();
            }
            if (!this.isDerived()) {
                if (this.derivedServices != null) {
                    for (ServiceController serviceController : this.derivedServices) {
                        serviceController.stop();
                    }
                }
                this.active = false;
                this.doStop();
                this.doStart();
                this.active = true;
                if (this.derivedServices != null) {
                    for (ServiceController serviceController : this.derivedServices) {
                        serviceController.start();
                    }
                }
            }
            this.log.info(this.getServiceName() + " restarted successfully");
            if (this.serviceStateListener != null) {
                this.serviceStateListener.restarted();
            }
        }
    }

    @Override
    public void restart(String message) throws Exception {
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.log.warn(this.getServiceName() + " is not yet started");
                return;
            }
            if (!this.isDerived() && this.derivedServices != null) {
                for (ServiceController serviceController : this.derivedServices) {
                    serviceController.pause();
                }
            }
            this.doPause();
            this.log.info(this.getServiceName() + " is paused");
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(long timeout) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.log.warn(this.getServiceName() + " is not yet started");
                return;
            }
            if (!this.isDerived() && this.derivedServices != null) {
                for (ServiceController serviceController : this.derivedServices) {
                    serviceController.pause(timeout);
                }
            }
            this.doPause(timeout);
            this.log.info(this.getServiceName() + " is paused and will resume after " + timeout + " ms");
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused(timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.log.warn(this.getServiceName() + " is not yet started");
                return;
            }
            this.doResume();
            if (!this.isDerived() && this.derivedServices != null) {
                for (ServiceController serviceController : this.derivedServices) {
                    serviceController.resume();
                }
            }
            this.log.info(this.getServiceName() + " is resumed");
            if (this.serviceStateListener != null) {
                this.serviceStateListener.resumed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.log.debug(this.getServiceName() + " is already stopped");
                return;
            }
            if (this.serviceStateListener != null) {
                try {
                    this.serviceStateListener.stopped();
                }
                catch (Exception e) {
                    this.log.warn(e.getMessage(), e);
                }
            }
            if (!this.isDerived()) {
                if (this.derivedServices != null) {
                    for (ServiceController serviceController : this.derivedServices) {
                        serviceController.stop();
                    }
                }
                try {
                    this.log.info("Stopping " + this.getServiceName());
                    this.doStop();
                    this.log.info(this.getServiceName() + " stopped successfully");
                }
                catch (Exception e) {
                    this.log.error(this.getServiceName() + " was not stopped normally", e);
                }
            } else {
                this.log.info(this.getServiceName() + " stopped successfully");
            }
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.active;
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }
}

