/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.service.AbstractCoreService;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.ShutdownHooks;

public class AspectranCoreService
extends AbstractCoreService {
    private final Log log = LogFactory.getLog(this.getClass());
    private ShutdownHooks.Task shutdownTask;

    public AspectranCoreService(ApplicationAdapter applicationAdapter) {
        super(applicationAdapter);
    }

    public AspectranCoreService(CoreService rootService) {
        super(rootService);
    }

    protected void afterContextLoaded() throws Exception {
    }

    protected void beforeContextDestroy() {
    }

    @Override
    protected void doStart() throws Exception {
        this.startAspectranService();
        if (this.getSchedulerService() != null) {
            this.joinDerivedService(this.getSchedulerService());
        }
        if (!this.isDerived()) {
            this.registerShutdownTask();
        }
    }

    @Override
    protected void doPause() throws Exception {
    }

    @Override
    protected void doPause(long timeout) throws Exception {
    }

    @Override
    protected void doResume() throws Exception {
    }

    @Override
    protected void doStop() {
        this.clearDerivedService();
        this.stopAspectranService();
        this.removeShutdownTask();
    }

    private void startAspectranService() throws Exception {
        this.loadActivityContext();
        this.afterContextLoaded();
    }

    private void stopAspectranService() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Destroying all cached resources...");
        }
        this.beforeContextDestroy();
        this.destroyActivityContext();
    }

    private void registerShutdownTask() {
        if (this.shutdownTask == null) {
            this.shutdownTask = ShutdownHooks.add(() -> {
                if (this.isActive()) {
                    this.stop();
                }
            });
        }
    }

    private void removeShutdownTask() {
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
            this.shutdownTask = null;
        }
    }
}

