/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import java.io.PrintStream;

public class Aspectran {
    public static final String VERSION;
    public static final String POWERED_BY;
    public static final String POWERED_BY_LINK;
    public static final boolean STABLE;

    private Aspectran() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getPoweredBy() {
        return POWERED_BY;
    }

    public static String getPoweredByLink() {
        return POWERED_BY_LINK;
    }

    public static void printAboutMe(PrintStream out) {
        out.println("Aspectran:   " + VERSION);
        out.println("JVM:         " + System.getProperty("java.version") + " (\"" + System.getProperty("java.vm.vendor") + "\" " + System.getProperty("java.runtime.version") + ")");
        out.println("OS:          " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
    }

    public static void printPrettyAboutMe(PrintStream out) {
        out.println("-----------------------------------------------------------------");
        out.println(String.format(" %1$-9s : %2$s", "Aspectran", VERSION));
        out.println(String.format(" %1$-9s : %2$s", "JVM", System.getProperty("java.version") + " (\"" + System.getProperty("java.vm.vendor") + "\" " + System.getProperty("java.runtime.version") + ")"));
        out.println(String.format(" %1$-9s : %2$s", "OS", System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        out.println("-----------------------------------------------------------------");
    }

    public static void main(String[] args) {
        Aspectran.printPrettyAboutMe(System.out);
    }

    static {
        Package pkg = Aspectran.class.getPackage();
        VERSION = pkg != null && "The Aspectran Project".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : System.getProperty("aspectran.version", "6.0.z");
        POWERED_BY = "Powered by Aspectran " + VERSION;
        POWERED_BY_LINK = "<a href=\"http://www.aspectran.com\">Powered by Aspectran " + VERSION + "</a>";
        STABLE = !VERSION.matches("^.*\\.(RC|M)[0-9]+$");
    }
}

