/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.context.resource.AspectranClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class CustomObjectInputStream
extends ObjectInputStream {
    public CustomObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    public CustomObjectInputStream() throws IOException {
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(cl.getName(), false, AspectranClassLoader.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(cl);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        ClassLoader loader = AspectranClassLoader.getDefaultClassLoader();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, loader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            Class<?> proxyClass = Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
            return proxyClass;
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

