/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.LinkedCaseInsensitiveMap;
import com.aspectran.core.util.MultiValueMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LinkedCaseInsensitiveMultiValueMap<V>
implements MultiValueMap<String, V>,
Serializable {
    private static final long serialVersionUID = 2505523262093891621L;
    private final Map<String, List<V>> values;

    public LinkedCaseInsensitiveMultiValueMap() {
        this.values = new LinkedCaseInsensitiveMap<List<V>>(Locale.ENGLISH);
    }

    public LinkedCaseInsensitiveMultiValueMap(int initialCapacity) {
        this.values = new LinkedCaseInsensitiveMap<List<V>>(initialCapacity, Locale.ENGLISH);
    }

    @Override
    public V getFirst(String key) {
        List<V> headerValues = this.values.get(key);
        return headerValues != null ? (V)headerValues.get(0) : null;
    }

    @Override
    public void add(String key, V value) {
        List headerValues = this.values.computeIfAbsent(key, k -> new LinkedList());
        headerValues.add(value);
    }

    @Override
    public void set(String key, V value) {
        LinkedList<V> headerValues = new LinkedList<V>();
        headerValues.add(value);
        this.values.put(key, headerValues);
    }

    @Override
    public void setAll(Map<String, V> values) {
        for (Map.Entry<String, V> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void put(String key, V[] values) {
        LinkedList list = new LinkedList();
        if (values != null) {
            Collections.addAll(list, values);
        }
        this.put(key, list);
    }

    @Override
    public Map<String, V> toSingleValueMap() {
        LinkedHashMap<String, V> singleValueMap = new LinkedHashMap<String, V>(this.values.size());
        for (Map.Entry<String, List<V>> entry : this.values.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.values.get(key);
    }

    @Override
    public List<V> put(String key, List<V> value) {
        return this.values.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<V>> map) {
        this.values.putAll(map);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkedCaseInsensitiveMultiValueMap)) {
            return false;
        }
        LinkedCaseInsensitiveMultiValueMap otherValues = (LinkedCaseInsensitiveMultiValueMap)other;
        return this.values.equals(otherValues.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return this.values.toString();
    }
}

