/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.context.InsufficientEnvironmentException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

public class PBEncryptionUtils {
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndTripleDES";
    public static final String ENCRYPTION_ALGORITHM_KEY = "aspectran.encryption.algorithm";
    public static final String ENCRYPTION_PASSWORD_KEY = "aspectran.encryption.password";
    private static final String algorithm = StringUtils.trimWhitespace(SystemUtils.getProperty("aspectran.encryption.algorithm", "PBEWithMD5AndTripleDES"));
    private static final String password = StringUtils.trimWhitespace(SystemUtils.getProperty("aspectran.encryption.password"));

    public static String getAlgorithm() {
        return algorithm;
    }

    public static String getPassword() {
        return password;
    }

    public static String encrypt(String inputString) {
        return PBEncryptionUtils.encrypt(inputString, password);
    }

    public static String encrypt(String inputString, String encryptionPassword) {
        return PBEncryptionUtils.getEncryptor(encryptionPassword).encrypt(inputString);
    }

    public static String decrypt(String inputString) {
        return PBEncryptionUtils.decrypt(inputString, password);
    }

    public static String decrypt(String inputString, String encryptionPassword) {
        PBEncryptionUtils.checkPassword(encryptionPassword);
        return PBEncryptionUtils.getEncryptor(encryptionPassword).decrypt(inputString);
    }

    public static PBEStringEncryptor getEncryptor() {
        return PBEncryptionUtils.getEncryptor(password);
    }

    public static PBEStringEncryptor getEncryptor(String encryptionPassword) {
        PBEncryptionUtils.checkPassword(encryptionPassword);
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(algorithm);
        encryptor.setPassword(encryptionPassword);
        return encryptor;
    }

    private static void checkPassword(String encryptionPassword) {
        if (!StringUtils.hasText(encryptionPassword)) {
            throw new InsufficientEnvironmentException("A password is required to attempt password-based encryption or decryption; Make sure the JVM system property \"aspectran.encryption.password\" is set up; (Default algorithm: " + PBEncryptionUtils.getAlgorithm() + ")");
        }
    }
}

