/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String JAR_FILE_SUFFIX = ".jar";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String REGULAR_FILE_SEPARATOR = "/";
    public static final char REGULAR_FILE_SEPARATOR_CHAR = '/';

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static URL getURL(String resourceLocation, ClassLoader classLoader) throws FileNotFoundException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("resourceLocation must not be null");
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = classLoader.getResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static File getFile(String resourceLocation, ClassLoader classLoader) throws FileNotFoundException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("resourceLocation must not be null");
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            URL url = classLoader.getResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system");
            }
            return ResourceUtils.getFile(url, description);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        if (resourceUrl == null) {
            throw new IllegalArgumentException("resourceUrl must not be null");
        }
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUri, "URI");
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        if (resourceUri == null) {
            throw new IllegalArgumentException("resourceUri must not be null");
        }
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isJarURL(URL url) {
        return URL_PROTOCOL_JAR.equals(url.getProtocol());
    }

    public static boolean isJarSimilarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith(REGULAR_FILE_SEPARATOR)) {
                    jarFile = REGULAR_FILE_SEPARATOR + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }

    public static URL getResource(String resource) throws IOException {
        return ResourceUtils.getResource(resource, AspectranClassLoader.getDefaultClassLoader());
    }

    public static URL getResource(String resource, ClassLoader classLoader) throws IOException {
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(resource);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resource);
        }
        if (url == null) {
            throw new IOException("Could not find resource '" + resource + "'");
        }
        return url;
    }

    public static File getResourceAsFile(String resource) throws IOException {
        return ResourceUtils.getFile(ResourceUtils.getResource(resource));
    }

    public static File getResourceAsFile(String resource, ClassLoader classLoader) throws IOException {
        return ResourceUtils.getFile(ResourceUtils.getResource(resource, classLoader));
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        return ResourceUtils.getResourceAsStream(resource, AspectranClassLoader.getDefaultClassLoader());
    }

    public static InputStream getResourceAsStream(String resource, ClassLoader classLoader) throws IOException {
        InputStream in = null;
        if (classLoader != null) {
            in = classLoader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return in;
    }

    public static Reader getReader(final File file, String encoding) throws IOException {
        InputStream stream;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(stream, encoding) : new InputStreamReader(stream);
        return reader;
    }

    public static Reader getReader(final URL url, String encoding) throws IOException {
        InputStream stream;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    URLConnection connection;
                    InputStream is = null;
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        is = connection.getInputStream();
                    }
                    return is;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(stream, encoding) : new InputStreamReader(stream);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String encoding) throws IOException {
        String source;
        try (Reader reader = ResourceUtils.getReader(file, encoding);){
            source = ResourceUtils.read(reader);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL url, String encoding) throws IOException {
        String source;
        try (Reader reader = ResourceUtils.getReader(url, encoding);){
            source = ResourceUtils.read(reader);
        }
        return source;
    }

    public static String read(Reader reader) throws IOException {
        int len;
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((len = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }
}

