/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import java.io.Writer;

public class StringOutputWriter
extends Writer {
    private final StringBuilder buffer;

    public StringOutputWriter() {
        this.buffer = new StringBuilder();
    }

    public StringOutputWriter(int initialSize) {
        this.buffer = new StringBuilder(initialSize);
    }

    @Override
    public void write(int c) {
        this.buffer.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buffer.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buffer.append(str, off, off + len);
    }

    @Override
    public StringOutputWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public StringOutputWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public StringOutputWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

