/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class StringUtils {
    public static final String EMPTY = "";

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        int index = 0;
        while (buf.length() > index) {
            if (Character.isWhitespace(buf.charAt(index))) {
                buf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return buf.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && buf.charAt(0) == leadingCharacter) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && buf.charAt(buf.length() - 1) == trailingCharacter) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.length() >= prefix.length() && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str != null && suffix != null && str.length() >= suffix.length() && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String nullToEmpty(String str) {
        return str != null ? str : EMPTY;
    }

    public static String emptyToNull(String str) {
        return str == null || str.length() == 0 ? null : str;
    }

    public static boolean startsWith(String str, char prefix) {
        return str != null && !str.isEmpty() && str.charAt(0) == prefix;
    }

    public static boolean endsWith(String str, char suffix) {
        return str != null && !str.isEmpty() && str.charAt(str.length() - 1) == suffix;
    }

    public static String replace(String str, String search, String replace) {
        int index;
        if (str == null || search == null || replace == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int searchLen = search.length();
        int stringLen = str.length();
        int oldIndex = 0;
        while ((index = str.indexOf(search, oldIndex)) >= 0) {
            sb.append(str, oldIndex, index);
            sb.append(replace);
            oldIndex = index + searchLen;
        }
        if (oldIndex < stringLen) {
            sb.append(str, oldIndex, stringLen);
        }
        return sb.toString();
    }

    public static String replace(String str, String[] search, String[] replace) {
        if (str == null || search == null || replace == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int loop = search.length <= replace.length ? search.length : replace.length;
        int start = 0;
        for (int i = 0; i < loop; ++i) {
            if (search[i] == null || replace[i] == null) continue;
            int searchLen = search[i].length();
            int replaceLen = replace[i].length();
            while (sb.length() != 0 && (start = sb.indexOf(search[i], start + replaceLen)) != -1) {
                int end = start + searchLen;
                sb.replace(start, end, replace[i]);
            }
        }
        return sb.toString();
    }

    public static String[] split(String str, String delim) {
        if (StringUtils.isEmpty(str)) {
            return new String[0];
        }
        int cnt = StringUtils.search(str, delim);
        String[] item = new String[cnt + 1];
        if (cnt == 0) {
            item[0] = str;
            return item;
        }
        int idx = 0;
        int pos1 = 0;
        int pos2 = str.indexOf(delim);
        int delimLen = delim.length();
        while (pos2 >= 0) {
            item[idx++] = pos1 > pos2 - 1 ? EMPTY : str.substring(pos1, pos2);
            pos1 = pos2 + delimLen;
            pos2 = str.indexOf(delim, pos1);
        }
        if (pos1 < str.length()) {
            item[idx] = str.substring(pos1);
        }
        if (item[cnt] == null) {
            item[cnt] = EMPTY;
        }
        return item;
    }

    public static String[] split(String str, String delim, int size) {
        String[] arr1 = new String[size];
        String[] arr2 = StringUtils.split(str, delim);
        for (int i = 0; i < arr1.length; ++i) {
            arr1[i] = i < arr2.length ? arr2[i] : EMPTY;
        }
        return arr1;
    }

    public static String[] split(String str, char delim) {
        if (StringUtils.isEmpty(str)) {
            return new String[0];
        }
        int cnt = StringUtils.search((CharSequence)str, delim);
        String[] item = new String[cnt + 1];
        if (cnt == 0) {
            item[0] = str;
            return item;
        }
        int idx = 0;
        int pos1 = 0;
        int pos2 = str.indexOf(delim);
        while (pos2 >= 0) {
            item[idx++] = pos1 > pos2 - 1 ? EMPTY : str.substring(pos1, pos2);
            pos1 = pos2 + 1;
            pos2 = str.indexOf(delim, pos1);
        }
        if (pos1 < str.length()) {
            item[idx] = str.substring(pos1);
        }
        if (item[cnt] == null) {
            item[cnt] = EMPTY;
        }
        return item;
    }

    public static String[] split(String str, char delim, int size) {
        String[] arr1 = new String[size];
        String[] arr2 = StringUtils.split(str, delim);
        for (int i = 0; i < arr1.length; ++i) {
            arr1[i] = i < arr2.length ? arr2[i] : EMPTY;
        }
        return arr1;
    }

    public static int search(String str, String keyw) {
        int strLen = str.length();
        int keywLen = keyw.length();
        int pos = 0;
        int cnt = 0;
        if (keywLen == 0) {
            return 0;
        }
        while ((pos = str.indexOf(keyw, pos)) != -1) {
            ++cnt;
            if ((pos += keywLen) < strLen) continue;
            break;
        }
        return cnt;
    }

    public static int searchIgnoreCase(String str, String keyw) {
        return StringUtils.search(str.toLowerCase(), keyw.toLowerCase());
    }

    public static int search(CharSequence chars, char c) {
        int count = 0;
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int searchIgnoreCase(CharSequence chars, char c) {
        int count = 0;
        char cl = Character.toLowerCase(c);
        for (int i = 0; i < chars.length(); ++i) {
            if (Character.toLowerCase(chars.charAt(i)) != cl) continue;
            ++count;
        }
        return count;
    }

    public static String[] tokenize(String str, String delimiters) {
        return StringUtils.tokenize(str, delimiters, false);
    }

    public static String[] tokenize(String str, String delimiters, boolean trim) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(trim ? st.nextToken().trim() : st.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    public static String toDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return EMPTY;
        }
        if (arr.length == 1) {
            return arr[0] == null ? EMPTY : arr[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String toDelimitedString(Collection<?> list, String delim) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(o);
            first = false;
        }
        return sb.toString();
    }

    public static String toLineDelimitedString(Object[] arr) {
        return StringUtils.toDelimitedString(arr, System.lineSeparator());
    }

    public static String toLineDelimitedString(Collection<?> list) {
        return StringUtils.toDelimitedString(list, System.lineSeparator());
    }

    public static String[] splitCommaDelimitedString(String str) {
        return StringUtils.tokenize(str, ",", true);
    }

    public static String joinCommaDelimitedList(String[] arr) {
        return StringUtils.toDelimitedString(arr, ", ");
    }

    public static String joinCommaDelimitedList(Collection<?> list) {
        return StringUtils.toDelimitedString(list, ", ");
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = StringUtils.tokenize(localeString, "_ ", false);
        String language = parts.length > 0 ? parts[0] : EMPTY;
        String country = parts.length > 1 ? parts[1] : EMPTY;
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = EMPTY;
        if (parts.length > 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == '_' || ch == ' ' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : EMPTY);
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String convertToHumanFriendlyByteSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(size)) / 10;
        double d = (double)size / (double)(1L << z * 10);
        String format = d % 1.0 == 0.0 ? "%.0f %sB" : "%.1f %sB";
        return String.format(format, d, Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static long convertToMachineFriendlyByteSize(String size) {
        double d;
        try {
            d = Double.parseDouble(size.replaceAll("[GMK]?[B]?$", EMPTY));
        }
        catch (NumberFormatException e) {
            String msg = "Size must be specified as bytes (B), kilobytes (KB), megabytes (MB), gigabytes (GB). E.g. 1024, 1KB, 10M, 10MB, 100G, 100GB";
            throw new NumberFormatException(msg + " " + e.getMessage());
        }
        long l = Math.round(d * 1024.0 * 1024.0 * 1024.0);
        int index = Math.max(0, size.length() - (size.endsWith("B") ? 2 : 1));
        switch (size.charAt(index)) {
            default: {
                l /= 1024L;
            }
            case 'K': {
                l /= 1024L;
            }
            case 'M': {
                l /= 1024L;
            }
            case 'G': 
        }
        return l;
    }
}

