/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterDefinition;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.ParameterValueType;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.UnknownParameterException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractParameters
implements Parameters {
    private final Map<String, ParameterValue> parameterValueMap = new LinkedHashMap<String, ParameterValue>();
    private final boolean addable;
    private Parameter identifier;
    private String indentString;

    protected AbstractParameters(ParameterDefinition[] parameterDefinitions) {
        if (parameterDefinitions != null) {
            for (ParameterDefinition pd : parameterDefinitions) {
                ParameterValue pv = pd.newParameterValue();
                pv.setContainer(this);
                this.parameterValueMap.put(pd.getName(), pv);
            }
            this.addable = false;
        } else {
            this.addable = true;
        }
    }

    @Override
    public Parameter getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(Parameter identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getQualifiedName() {
        if (this.identifier != null) {
            return this.identifier.getQualifiedName();
        }
        return this.getClass().getName();
    }

    @Override
    public Parameter getParent() {
        if (this.identifier != null && this.identifier.getContainer() != null && this.identifier.getContainer().getIdentifier() != null) {
            return this.identifier.getContainer().getIdentifier();
        }
        return null;
    }

    @Override
    public void updateContainer(Parameters parameters) {
        for (ParameterValue parameterValue : parameters.getParameterValueMap().values()) {
            parameterValue.setContainer(parameters);
        }
    }

    @Override
    public Map<String, ParameterValue> getParameterValueMap() {
        return this.parameterValueMap;
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterValueMap.keySet().toArray(new String[0]);
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.parameterValueMap.keySet();
    }

    @Override
    public boolean hasParameter(String name) {
        return this.parameterValueMap.get(name) != null;
    }

    @Override
    public boolean hasParameter(ParameterDefinition parameterDefinition) {
        return this.hasParameter(parameterDefinition.getName());
    }

    @Override
    public boolean isAssigned(String name) {
        Parameter p = this.parameterValueMap.get(name);
        return p != null && p.isAssigned();
    }

    @Override
    public boolean isAssigned(ParameterDefinition parameterDefinition) {
        return this.isAssigned(parameterDefinition.getName());
    }

    @Override
    public boolean hasValue(String name) {
        Parameter p = this.parameterValueMap.get(name);
        return p != null && p.hasValue();
    }

    @Override
    public boolean hasValue(ParameterDefinition parameterDefinition) {
        Parameter p = this.parameterValueMap.get(parameterDefinition.getName());
        return p != null && p.hasValue();
    }

    @Override
    public Parameter getParameter(String name) {
        Parameter p = this.parameterValueMap.get(name);
        if (!this.addable && p == null) {
            throw new UnknownParameterException(name, this);
        }
        return p;
    }

    @Override
    public Parameter getParameter(ParameterDefinition parameterDefinition) {
        return this.getParameter(parameterDefinition.getName());
    }

    @Override
    public Object getValue(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValue() : null;
    }

    @Override
    public Object getValue(ParameterDefinition parameterDefinition) {
        return this.getValue(parameterDefinition.getName());
    }

    @Override
    public void putAll(Parameters parameters) {
        for (ParameterValue parameterValue : parameters.getParameterValueMap().values()) {
            parameterValue.setContainer(this);
        }
        this.parameterValueMap.putAll(parameters.getParameterValueMap());
    }

    @Override
    public void putValue(String name, Object value) {
        Parameter p = this.getParameter(name);
        if (p == null) {
            p = this.newParameterValue(name, ParameterValueType.determineValueType(value));
        }
        p.putValue(value);
        if (value instanceof Parameters) {
            ((Parameters)value).updateContainer(this);
        }
    }

    @Override
    public void putValue(ParameterDefinition parameterDefinition, Object value) {
        this.putValue(parameterDefinition.getName(), value);
    }

    @Override
    public void putValueNonNull(String name, Object value) {
        if (value != null) {
            this.putValue(name, value);
        }
    }

    @Override
    public void putValueNonNull(ParameterDefinition parameterDefinition, Object value) {
        if (value != null) {
            this.putValue(parameterDefinition.getName(), value);
        }
    }

    @Override
    public void clearValue(String name) {
        if (this.addable) {
            this.parameterValueMap.remove(name);
        } else {
            Parameter p = this.getParameter(name);
            if (p != null) {
                p.clearValue();
            }
        }
    }

    @Override
    public void clearValue(ParameterDefinition parameterDefinition) {
        this.clearValue(parameterDefinition.getName());
    }

    @Override
    public String getString(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsString() : null;
    }

    @Override
    public String getString(String name, String defaultValue) {
        String s = this.getString(name);
        return s != null ? s : defaultValue;
    }

    @Override
    public String getString(ParameterDefinition parameterDefinition) {
        return this.getString(parameterDefinition.getName());
    }

    @Override
    public String getString(ParameterDefinition parameterDefinition, String defaultValue) {
        return this.getString(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public String[] getStringArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringArray() : null;
    }

    @Override
    public String[] getStringArray(ParameterDefinition parameterDefinition) {
        return this.getStringArray(parameterDefinition.getName());
    }

    @Override
    public List<String> getStringList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringList() : null;
    }

    @Override
    public List<String> getStringList(ParameterDefinition parameterDefinition) {
        return this.getStringList(parameterDefinition.getName());
    }

    @Override
    public Integer getInt(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsInt() : null;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Integer val = p.getValueAsInt();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Integer[] getIntArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntArray() : null;
    }

    @Override
    public Integer getInt(ParameterDefinition parameterDefinition) {
        return this.getInt(parameterDefinition.getName());
    }

    @Override
    public int getInt(ParameterDefinition parameterDefinition, int defaultValue) {
        return this.getInt(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public Integer[] getIntArray(ParameterDefinition parameterDefinition) {
        return this.getIntArray(parameterDefinition.getName());
    }

    @Override
    public List<Integer> getIntList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntList() : null;
    }

    @Override
    public List<Integer> getIntList(ParameterDefinition parameterDefinition) {
        return this.getIntList(parameterDefinition.getName());
    }

    @Override
    public Long getLong(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLong() : null;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Long val = p.getValueAsLong();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Long getLong(ParameterDefinition parameterDefinition) {
        return this.getLong(parameterDefinition.getName());
    }

    @Override
    public long getLong(ParameterDefinition parameterDefinition, long defaultValue) {
        return this.getLong(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public Long[] getLongArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongArray() : null;
    }

    @Override
    public Long[] getLongArray(ParameterDefinition parameterDefinition) {
        return this.getLongArray(parameterDefinition.getName());
    }

    @Override
    public List<Long> getLongList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongList() : null;
    }

    @Override
    public List<Long> getLongList(ParameterDefinition parameterDefinition) {
        return this.getLongList(parameterDefinition.getName());
    }

    @Override
    public Float getFloat(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloat() : null;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Float val = p.getValueAsFloat();
            return val != null ? val.floatValue() : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Float getFloat(ParameterDefinition parameterDefinition) {
        return this.getFloat(parameterDefinition.getName());
    }

    @Override
    public float getFloat(ParameterDefinition parameterDefinition, float defaultValue) {
        return this.getFloat(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public Float[] getFloatArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatArray() : null;
    }

    @Override
    public Float[] getFloatArray(ParameterDefinition parameterDefinition) {
        return this.getFloatArray(parameterDefinition.getName());
    }

    @Override
    public List<Float> getFloatList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatList() : null;
    }

    @Override
    public List<Float> getFloatList(ParameterDefinition parameterDefinition) {
        return this.getFloatList(parameterDefinition.getName());
    }

    @Override
    public Double getDouble(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDouble() : null;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Double val = p.getValueAsDouble();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(ParameterDefinition parameterDefinition) {
        return this.getDouble(parameterDefinition.getName());
    }

    @Override
    public double getDouble(ParameterDefinition parameterDefinition, double defaultValue) {
        return this.getDouble(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public Double[] getDoubleArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleArray() : null;
    }

    @Override
    public Double[] getDoubleArray(ParameterDefinition parameterDefinition) {
        return this.getDoubleArray(parameterDefinition.getName());
    }

    @Override
    public List<Double> getDoubleList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleList() : null;
    }

    @Override
    public List<Double> getDoubleList(ParameterDefinition parameterDefinition) {
        return this.getDoubleList(parameterDefinition.getName());
    }

    @Override
    public Boolean getBoolean(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBoolean() : null;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Parameter p = this.getParameter(name);
        return p != null ? BooleanUtils.toBoolean(p.getValueAsBoolean(), defaultValue) : defaultValue;
    }

    @Override
    public Boolean getBoolean(ParameterDefinition parameterDefinition) {
        return this.getBoolean(parameterDefinition.getName());
    }

    @Override
    public boolean getBoolean(ParameterDefinition parameterDefinition, boolean defaultValue) {
        return this.getBoolean(parameterDefinition.getName(), defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanArray() : null;
    }

    @Override
    public Boolean[] getBooleanArray(ParameterDefinition parameterDefinition) {
        return this.getBooleanArray(parameterDefinition.getName());
    }

    @Override
    public List<Boolean> getBooleanList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanList() : null;
    }

    @Override
    public List<Boolean> getBooleanList(ParameterDefinition parameterDefinition) {
        return this.getBooleanList(parameterDefinition.getName());
    }

    @Override
    public <T extends Parameters> T getParameters(String name) {
        Parameter p = this.getParameter(name);
        return (T)(p != null ? (Parameters)p.getValue() : null);
    }

    @Override
    public <T extends Parameters> T getParameters(ParameterDefinition parameterDefinition) {
        return this.getParameters(parameterDefinition.getName());
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersArray() : null;
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(ParameterDefinition parameterDefinition) {
        return this.getParametersArray(parameterDefinition.getName());
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersList() : null;
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(ParameterDefinition parameterDefinition) {
        return this.getParametersList(parameterDefinition.getName());
    }

    @Override
    public ParameterValue newParameterValue(String name, ParameterValueType parameterValueType) {
        return this.newParameterValue(name, parameterValueType, false);
    }

    @Override
    public ParameterValue newParameterValue(String name, ParameterValueType parameterValueType, boolean array) {
        ParameterValue pv = new ParameterValue(name, parameterValueType, array);
        pv.setContainer(this);
        this.parameterValueMap.put(name, pv);
        return pv;
    }

    @Override
    public <T extends Parameters> T newParameters(String name) {
        Parameter p = this.getParameter(name);
        if (p == null) {
            throw new UnknownParameterException(name, this);
        }
        Parameters parameters = p.newParameters(p);
        return (T)parameters;
    }

    @Override
    public <T extends Parameters> T newParameters(ParameterDefinition parameterDefinition) {
        return this.newParameters(parameterDefinition.getName());
    }

    @Override
    public <T extends Parameters> T touchParameters(String name) {
        T parameters = this.getParameters(name);
        if (parameters == null) {
            parameters = this.newParameters(name);
        }
        return parameters;
    }

    @Override
    public <T extends Parameters> T touchParameters(ParameterDefinition parameterDefinition) {
        return this.touchParameters(parameterDefinition.getName());
    }

    @Override
    public boolean isAddable() {
        return this.addable;
    }

    @Override
    public String describe() {
        return this.describe(false);
    }

    @Override
    public String describe(boolean details) {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("qualifiedName", this.getQualifiedName());
        if (details) {
            tsb.append("parameters", this.parameterValueMap);
        } else {
            tsb.append("parameters", this.getParameterNames());
        }
        tsb.append("parent", this.getParent());
        return tsb.toString();
    }

    @Override
    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    @Override
    public void readFrom(String text) throws AponParseException {
        if (text != null) {
            AponReader.parse(text, this);
        }
    }

    public String toString() {
        if (this.indentString != null) {
            return AponWriter.stringify((Parameters)this, this.indentString);
        }
        return AponWriter.stringify(this);
    }
}

