/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

public class AponFormat {
    protected static final char CURLY_BRACKET_OPEN = '{';
    protected static final char CURLY_BRACKET_CLOSE = '}';
    protected static final char SQUARE_BRACKET_OPEN = '[';
    protected static final char SQUARE_BRACKET_CLOSE = ']';
    protected static final char ROUND_BRACKET_OPEN = '(';
    protected static final char ROUND_BRACKET_CLOSE = ')';
    public static final char TEXT_LINE_START = '|';
    protected static final char NAME_VALUE_SEPARATOR = ':';
    protected static final char COMMENT_LINE_START = '#';
    protected static final char NO_CONTROL_CHAR = '\u0000';
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final char ESCAPE_CHAR = '\\';
    public static final char NEW_LINE_CHAR = '\n';
    public static final String NEW_LINE = System.lineSeparator();
    protected static final String INDENT_STRING = "\t";
    protected static final String SPACE = " ";
    protected static final char SPACE_CHAR = ' ';
    protected static final String NULL = "null";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";

    public static String escape(String value, boolean noQuote) {
        if (value == null) {
            return null;
        }
        int vlen = value.length();
        if (vlen == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(vlen);
        block8: for (int i = 0; i < vlen; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    if (!noQuote) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String value) {
        if (value == null) {
            return null;
        }
        int vlen = value.length();
        if (vlen == 0 || value.indexOf(92) == -1) {
            return value;
        }
        StringBuilder sb = new StringBuilder(vlen);
        block8: for (int i = 0; i < vlen; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                c = ++i < vlen ? value.charAt(i) : (char)'\u0000';
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(c);
                        continue block8;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block8;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block8;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block8;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block8;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block8;
                    }
                    default: {
                        return null;
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

