/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.apon.AponFormat;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.AponSyntaxException;
import com.aspectran.core.util.apon.MissingClosingBracketException;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.ParameterValueType;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;

public class AponReader
extends AponFormat {
    private BufferedReader reader;
    private boolean addable;
    private int lineNumber;

    public AponReader(String text) {
        this(new StringReader(text));
    }

    public AponReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Parameters read() throws AponParseException {
        VariableParameters parameters = new VariableParameters();
        return this.read(parameters);
    }

    public <T extends Parameters> T read(T parameters) throws AponParseException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        this.addable = parameters.isAddable();
        try {
            this.valuelize(parameters, '\u0000', null, null, null, false);
        }
        catch (AponParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AponParseException("Could not read an APON formatted document into a Parameters object", e);
        }
        return parameters;
    }

    private void valuelize(Parameters parameters, char openBracket, String name, ParameterValue parameterValue, ParameterValueType parameterValueType, boolean valueTypeHinted) throws IOException, AponParseException {
        String line;
        Map<String, ParameterValue> parameterValueMap = parameters.getParameterValueMap();
        while ((line = this.reader.readLine()) != null) {
            char cchar;
            int vlen;
            String value;
            ++this.lineNumber;
            String tline = line.trim();
            int tlen = tline.length();
            if (tlen == 0 || tline.charAt(0) == '#' && openBracket != '[') continue;
            if (openBracket == '[') {
                value = tline;
                vlen = value.length();
                char c = cchar = vlen == 1 ? value.charAt(0) : (char)'\u0000';
                if (']' == cchar) {
                    return;
                }
            } else {
                if (tlen == 1 && openBracket == '{' && '}' == tline.charAt(0)) {
                    return;
                }
                int index = tline.indexOf(58);
                if (index == -1) {
                    throw new AponSyntaxException(this.lineNumber, line, tline, "Failed to break up string of name/value pairs");
                }
                if (index == 0) {
                    throw new AponSyntaxException(this.lineNumber, line, tline, "Unrecognized parameter name");
                }
                name = tline.substring(0, index).trim();
                value = tline.substring(index + 1).trim();
                vlen = value.length();
                cchar = vlen == 1 ? value.charAt(0) : (char)'\u0000';
                parameterValue = parameterValueMap.get(name);
                if (parameterValue != null) {
                    parameterValueType = parameterValue.getParameterValueType();
                } else {
                    if (!this.addable) {
                        throw new AponSyntaxException(this.lineNumber, line, tline, "Parameter '" + name + "' is not predefined; Note that only predefined parameters are allowed");
                    }
                    parameterValueType = ParameterValueType.resolveByHint(name);
                    if (parameterValueType != null) {
                        valueTypeHinted = true;
                        parameterValue = parameterValueMap.get(name = ParameterValueType.stripValueTypeHint(name));
                        if (parameterValue != null) {
                            parameterValueType = parameterValue.getParameterValueType();
                        }
                    } else {
                        valueTypeHinted = false;
                    }
                }
                if (parameterValueType == ParameterValueType.VARIABLE) {
                    parameterValueType = null;
                }
                if (parameterValueType != null) {
                    if (parameterValue != null && !parameterValue.isArray() && '[' == cchar) {
                        throw new AponSyntaxException(this.lineNumber, line, tline, "Parameter value is not an array type");
                    }
                    if (parameterValueType != ParameterValueType.PARAMETERS && '{' == cchar) {
                        throw new AponSyntaxException(this.lineNumber, line, tline, parameterValue, parameterValueType);
                    }
                    if (parameterValueType != ParameterValueType.TEXT && '(' == cchar) {
                        throw new AponSyntaxException(this.lineNumber, line, tline, parameterValue, parameterValueType);
                    }
                }
            }
            if (parameterValue != null && !parameterValue.isArray()) {
                if (parameterValueType == ParameterValueType.PARAMETERS && '{' != cchar) {
                    throw new AponSyntaxException(this.lineNumber, line, tline, parameterValue, parameterValueType);
                }
                if (parameterValueType == ParameterValueType.TEXT && '(' != cchar) {
                    throw new AponSyntaxException(this.lineNumber, line, tline, parameterValue, parameterValueType);
                }
            }
            if ((parameterValue == null || parameterValue.isArray() || parameterValueType == null) && '[' == cchar) {
                this.valuelize(parameters, '[', name, parameterValue, parameterValueType, valueTypeHinted);
                continue;
            }
            if (parameterValueType == null) {
                if ('{' == cchar) {
                    parameterValueType = ParameterValueType.PARAMETERS;
                } else if ('(' == cchar) {
                    parameterValueType = ParameterValueType.TEXT;
                }
            }
            if (parameterValueType == ParameterValueType.PARAMETERS) {
                if (parameterValue == null) {
                    parameterValue = parameters.newParameterValue(name, parameterValueType, openBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                }
                Object parameters2 = parameters.newParameters(parameterValue.getName());
                this.addable = parameters2.isAddable();
                this.valuelize((Parameters)parameters2, '{', null, null, null, valueTypeHinted);
            } else if (parameterValueType == ParameterValueType.TEXT) {
                if (parameterValue == null) {
                    parameterValue = parameters.newParameterValue(name, parameterValueType, openBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                }
                if ('(' == cchar) {
                    parameterValue.putValue(this.valuelizeText());
                } else if ("null".equals(value)) {
                    parameterValue.putValue(null);
                } else {
                    parameterValue.putValue(value);
                }
            } else {
                if (vlen == 0) {
                    value = null;
                    if (parameterValueType == null) {
                        parameterValueType = ParameterValueType.STRING;
                    }
                } else if (parameterValueType == null) {
                    if ("null".equals(value)) {
                        value = null;
                        parameterValueType = ParameterValueType.STRING;
                    } else if ("true".equals(value) || "false".equals(value)) {
                        parameterValueType = ParameterValueType.BOOLEAN;
                    } else if (value.charAt(0) == '\"') {
                        if (vlen == 1 || value.charAt(vlen - 1) != '\"') {
                            throw new AponSyntaxException(this.lineNumber, line, tline, "Unclosed quotation mark after the character string " + value);
                        }
                        parameterValueType = ParameterValueType.STRING;
                    } else if (value.charAt(0) == '\'') {
                        if (vlen == 1 || value.charAt(vlen - 1) != '\'') {
                            throw new AponSyntaxException(this.lineNumber, line, tline, "Unclosed quotation mark after the character string " + value);
                        }
                        parameterValueType = ParameterValueType.STRING;
                    } else {
                        try {
                            Integer.parseInt(value);
                            parameterValueType = ParameterValueType.INT;
                        }
                        catch (NumberFormatException e1) {
                            try {
                                Long.parseLong(value);
                                parameterValueType = ParameterValueType.LONG;
                            }
                            catch (NumberFormatException e2) {
                                try {
                                    Float.parseFloat(value);
                                    parameterValueType = ParameterValueType.FLOAT;
                                }
                                catch (NumberFormatException e3) {
                                    try {
                                        Double.parseDouble(value);
                                        parameterValueType = ParameterValueType.DOUBLE;
                                    }
                                    catch (NumberFormatException e4) {
                                        parameterValueType = ParameterValueType.STRING;
                                    }
                                }
                            }
                        }
                    }
                } else if ("null".equals(value)) {
                    value = null;
                }
                if (parameterValue == null) {
                    parameterValue = parameters.newParameterValue(name, parameterValueType, openBracket == '[');
                    parameterValue.setValueTypeHinted(valueTypeHinted);
                } else if (parameterValue.getParameterValueType() == ParameterValueType.VARIABLE) {
                    parameterValue.setParameterValueType(parameterValueType);
                } else if (parameterValue.getParameterValueType() != parameterValueType) {
                    throw new AponSyntaxException(this.lineNumber, line, tline, parameterValue, parameterValue.getParameterValueType());
                }
                if (value == null) {
                    parameterValue.putValue(null);
                } else if (parameterValueType == ParameterValueType.STRING) {
                    if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
                        value = this.unescape(value.substring(1, vlen - 1), this.lineNumber, line, tline);
                    }
                    parameterValue.putValue(value);
                } else if (parameterValueType == ParameterValueType.BOOLEAN) {
                    parameterValue.putValue(Boolean.valueOf(value));
                } else if (parameterValueType == ParameterValueType.INT) {
                    parameterValue.putValue(Integer.valueOf(value));
                } else if (parameterValueType == ParameterValueType.LONG) {
                    parameterValue.putValue(Long.valueOf(value));
                } else if (parameterValueType == ParameterValueType.FLOAT) {
                    parameterValue.putValue(Float.valueOf(value));
                } else if (parameterValueType == ParameterValueType.DOUBLE) {
                    parameterValue.putValue(Double.valueOf(value));
                }
            }
            if (!parameterValue.isArray() || !parameterValue.isBracketed() || openBracket == '[') continue;
            parameterValue.setBracketed(false);
        }
        if (openBracket == '{') {
            throw new MissingClosingBracketException("curly", name, parameterValue);
        }
        if (openBracket == '[') {
            throw new MissingClosingBracketException("square", name, parameterValue);
        }
    }

    private String valuelizeText() throws IOException, AponSyntaxException {
        String line;
        String tline = null;
        StringBuilder sb = null;
        while ((line = this.reader.readLine()) != null) {
            char tchar;
            ++this.lineNumber;
            tline = line.trim();
            int tlen = tline.length();
            char c = tchar = tlen > 0 ? tline.charAt(0) : (char)'\u0000';
            if (tlen == 1 && ')' == tchar) {
                return sb != null ? sb.toString() : "";
            }
            if ('|' == tchar) {
                String str;
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append(NEW_LINE);
                }
                if ((str = line.substring(line.indexOf(124) + 1)).length() <= 0) continue;
                sb.append(str);
                continue;
            }
            if (tlen <= 0) continue;
            throw new AponSyntaxException(this.lineNumber, line, tline, "The closing round bracket was missing or Each text line is must start with a '|'");
        }
        throw new AponSyntaxException(this.lineNumber, "", tline, "The end of the text line was reached with no closing round bracket found");
    }

    private String unescape(String value, int lineNumber, String line, String ltrim) throws AponSyntaxException {
        String s = AponReader.unescape(value);
        if (Objects.equals(value, s)) {
            return value;
        }
        if (s == null) {
            throw new AponSyntaxException(lineNumber, line, ltrim, "Invalid escape sequence (valid ones are  \\b  \\t  \\n  \\f  \\r  \\\"  \\\\ )");
        }
        return s;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    public static Parameters parse(String text) throws AponParseException {
        VariableParameters parameters = new VariableParameters();
        return AponReader.parse(text, parameters);
    }

    public static <T extends Parameters> T parse(String text, T parameters) throws AponParseException {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        try {
            AponReader aponReader = new AponReader(text);
            aponReader.read(parameters);
            aponReader.close();
            return parameters;
        }
        catch (AponParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AponParseException("Failed to parse string with APON format", e);
        }
    }

    public static Parameters parse(File file) throws AponParseException {
        return AponReader.parse(file, (String)null);
    }

    public static Parameters parse(File file, String encoding) throws AponParseException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        VariableParameters parameters = new VariableParameters();
        return AponReader.parse(file, encoding, parameters);
    }

    public static <T extends Parameters> T parse(File file, T parameters) throws AponParseException {
        return AponReader.parse(file, null, parameters);
    }

    public static <T extends Parameters> T parse(File file, String encoding, T parameters) throws AponParseException {
        T t;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        AponReader aponReader = null;
        try {
            aponReader = encoding == null ? new AponReader(new FileReader(file)) : new AponReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            t = aponReader.read(parameters);
        }
        catch (Exception e) {
            throw new AponParseException("Failed to parse string with APON format", e);
        }
        finally {
            if (aponReader != null) {
                try {
                    aponReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return t;
    }

    public static Parameters parse(Reader reader) throws AponParseException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        AponReader aponReader = new AponReader(reader);
        return aponReader.read();
    }

    public static <T extends Parameters> T parse(Reader reader, T parameters) throws AponParseException {
        AponReader aponReader = new AponReader(reader);
        aponReader.read(parameters);
        return parameters;
    }
}

