/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AponParseException;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.ParameterValueType;

public class AponSyntaxException
extends AponParseException {
    private static final long serialVersionUID = -2012813522496665651L;

    public AponSyntaxException(String msg) {
        super(msg);
    }

    public AponSyntaxException(int lineNumber, String line, String tline, String msg) {
        super(AponSyntaxException.makeMessage(lineNumber, line, tline, msg));
    }

    public AponSyntaxException(int lineNumber, String line, String tline, ParameterValue parameterValue, ParameterValueType expectedParameterValueType) {
        super(AponSyntaxException.makeMessage(lineNumber, line, tline, parameterValue, expectedParameterValueType));
    }

    private static String makeMessage(int lineNumber, String line, String tline, String msg) {
        int columnNumber = tline != null ? line.indexOf(tline) : 0;
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            sb.append(msg);
        }
        sb.append(" [lineNumber: ").append(lineNumber);
        if (columnNumber != -1) {
            String lspace = line.substring(0, columnNumber);
            int tabCnt = StringUtils.search(lspace, "\t");
            if (tline != null && tline.length() > 33) {
                tline = tline.substring(0, 30) + "...";
            }
            sb.append(", columnNumber: ").append(columnNumber + 1);
            if (tabCnt != 0) {
                sb.append(" (");
                sb.append("Tabs ").append(tabCnt);
                sb.append(", Spaces ").append(columnNumber - tabCnt);
                sb.append(")");
            }
            sb.append("] ").append(tline);
        }
        return sb.toString();
    }

    private static String makeMessage(int lineNumber, String line, String tline, ParameterValue parameterValue, ParameterValueType expectedParameterValueType) {
        StringBuilder sb = new StringBuilder();
        sb.append("Incompatible value type with expected value type '");
        sb.append((Object)expectedParameterValueType).append("'");
        if (parameterValue != null) {
            sb.append(" for the specified parameter ").append(parameterValue);
        }
        return AponSyntaxException.makeMessage(lineNumber, line, tline, sb.toString());
    }
}

