/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.apon.AponFormat;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterValueType;
import com.aspectran.core.util.apon.Parameters;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class AponWriter
extends AponFormat
implements Flushable,
Closeable {
    private Writer writer;
    private boolean prettyPrint;
    private String indentString;
    private int indentDepth;
    private boolean nullWrite;
    private boolean typeHintWrite;

    public AponWriter(Writer writer) {
        this(writer, true);
    }

    public AponWriter(Writer writer, boolean prettyPrint) {
        this.writer = writer;
        this.prettyPrint = prettyPrint;
        this.indentString = prettyPrint ? "\t" : null;
    }

    public AponWriter(Writer writer, String indentString) {
        this.writer = writer;
        this.prettyPrint = indentString != null;
        this.indentString = indentString;
    }

    public AponWriter(File file) throws IOException {
        this(file, false);
    }

    public AponWriter(File file, boolean append) throws IOException {
        this.writer = new FileWriter(file, append);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void setNullWrite(boolean nullWrite) {
        this.nullWrite = nullWrite;
    }

    public void setTypeHintWrite(boolean typeHintWrite) {
        this.typeHintWrite = typeHintWrite;
    }

    public void write(Parameters parameters) throws IOException {
        if (parameters != null) {
            for (Parameter parameter : parameters.getParameterValueMap().values()) {
                if (!parameter.isAssigned()) continue;
                this.write(parameter);
            }
        }
    }

    public void write(Parameter parameter) throws IOException {
        if (parameter.getParameterValueType() == ParameterValueType.PARAMETERS) {
            if (parameter.isArray()) {
                List<Parameters> list = parameter.getValueAsParametersList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.openSquareBracket();
                        for (Parameters p : list) {
                            this.indent();
                            this.openCurlyBracket();
                            this.write(p);
                            this.closeCurlyBracket();
                        }
                        this.closeSquareBracket();
                    } else {
                        for (Parameters p : list) {
                            this.writeName(parameter);
                            this.openCurlyBracket();
                            this.write(p);
                            this.closeCurlyBracket();
                        }
                    }
                }
            } else if (this.nullWrite || parameter.getValueAsParameters() != null) {
                this.writeName(parameter);
                this.openCurlyBracket();
                this.write(parameter.getValueAsParameters());
                this.closeCurlyBracket();
            }
        } else if (parameter.getParameterValueType() == ParameterValueType.VARIABLE) {
            if (parameter.isArray()) {
                List<?> list = parameter.getValueList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.openSquareBracket();
                        for (Object value : list) {
                            this.indent();
                            if (value instanceof Parameters) {
                                this.write((Parameters)value);
                                continue;
                            }
                            if (value != null) {
                                this.writeString(value.toString());
                                continue;
                            }
                            this.writeNull();
                        }
                        this.closeSquareBracket();
                    } else {
                        for (Object value : list) {
                            this.writeName(parameter);
                            if (value instanceof Parameters) {
                                this.write((Parameters)value);
                                continue;
                            }
                            if (value != null) {
                                this.writeString(value.toString());
                                continue;
                            }
                            this.writeNull();
                        }
                    }
                }
            } else {
                Object value = parameter.getValue();
                if (this.nullWrite || value != null) {
                    this.writeName(parameter);
                    this.openCurlyBracket();
                    if (value instanceof Parameters) {
                        this.write((Parameters)value);
                    } else if (value != null) {
                        this.writeString(value.toString());
                    } else {
                        this.writeNull();
                    }
                    this.closeCurlyBracket();
                }
            }
        } else if (parameter.getParameterValueType() == ParameterValueType.STRING) {
            if (parameter.isArray()) {
                List<String> list = parameter.getValueAsStringList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.openSquareBracket();
                        for (String value : list) {
                            this.indent();
                            this.writeString(value);
                        }
                        this.closeSquareBracket();
                    } else {
                        for (String value : list) {
                            this.writeName(parameter);
                            this.writeString(value);
                        }
                    }
                }
            } else {
                String s = parameter.getValueAsString();
                if (this.nullWrite || s != null) {
                    this.writeName(parameter);
                    this.writeString(s);
                }
            }
        } else if (parameter.getParameterValueType() == ParameterValueType.TEXT) {
            if (parameter.isArray()) {
                List<String> list = parameter.getValueAsStringList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.openSquareBracket();
                        for (String text : list) {
                            this.indent();
                            this.openRoundBracket();
                            this.writeText(text);
                            this.closeRoundBracket();
                        }
                        this.closeSquareBracket();
                    } else {
                        for (String text : list) {
                            this.writeName(parameter);
                            this.openRoundBracket();
                            this.writeText(text);
                            this.closeRoundBracket();
                        }
                    }
                }
            } else {
                String text = parameter.getValueAsString();
                if (text != null) {
                    this.writeName(parameter);
                    this.openRoundBracket();
                    this.writeText(text);
                    this.closeRoundBracket();
                } else if (this.nullWrite) {
                    this.writeName(parameter);
                    this.writeNull();
                }
            }
        } else if (parameter.isArray()) {
            List<?> list = parameter.getValueList();
            if (list != null) {
                if (parameter.isBracketed()) {
                    this.writeName(parameter);
                    this.openSquareBracket();
                    for (Object value : list) {
                        this.indent();
                        this.write(value);
                    }
                    this.closeSquareBracket();
                } else {
                    for (Object value : list) {
                        this.writeName(parameter);
                        this.write(value);
                    }
                }
            }
        } else if (this.nullWrite || parameter.getValue() != null) {
            this.writeName(parameter);
            this.write(parameter.getValue());
        }
    }

    public void comment(String message) throws IOException {
        if (message.indexOf(10) != -1) {
            String line;
            int start = 0;
            while ((line = this.readLine(message, start)) != null) {
                this.writer.write(35);
                this.writer.write(32);
                this.writer.write(line);
                this.newLine();
                start += line.length();
                if ((start = this.skipNewLineChar(message, start)) != -1) continue;
            }
            if (start != -1) {
                this.writer.write(35);
                this.newLine();
            }
        } else {
            this.writer.write(35);
            this.writer.write(32);
            this.writer.write(message);
            this.newLine();
        }
    }

    private void writeName(Parameter parameter) throws IOException {
        this.indent();
        this.writer.write(parameter.getName());
        if (this.typeHintWrite || parameter.isValueTypeHinted()) {
            this.writer.write(40);
            this.writer.write(parameter.getParameterValueType().toString());
            this.writer.write(41);
        }
        this.writer.write(58);
        this.writer.write(32);
    }

    private void writeString(String value) throws IOException {
        if (value == null) {
            this.writeNull();
        } else {
            if (value.isEmpty()) {
                this.writer.write(34);
                this.writer.write(34);
            } else if (value.startsWith(" ") || value.endsWith(" ")) {
                this.writer.write(34);
                this.writer.write(AponWriter.escape(value, false));
                this.writer.write(34);
            } else {
                this.writer.write(AponWriter.escape(value, true));
            }
            this.newLine();
        }
    }

    private void writeText(String text) throws IOException {
        String line;
        int start = 0;
        while ((line = this.readLine(text, start)) != null) {
            this.indent();
            this.writer.write(124);
            this.writer.write(line);
            this.newLine();
            start += line.length();
            if ((start = this.skipNewLineChar(text, start)) != -1) continue;
        }
        if (start != -1) {
            this.indent();
            this.writer.write(124);
            this.newLine();
        }
    }

    private void write(Object value) throws IOException {
        if (value != null) {
            this.writer.write(value.toString());
            this.newLine();
        } else {
            this.writeNull();
        }
    }

    private void writeNull() throws IOException {
        this.writer.write("null");
        this.newLine();
    }

    private void openCurlyBracket() throws IOException {
        this.writer.write(123);
        this.newLine();
        this.increaseIndent();
    }

    private void closeCurlyBracket() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(125);
        this.newLine();
    }

    private void openSquareBracket() throws IOException {
        this.writer.write(91);
        this.newLine();
        this.increaseIndent();
    }

    private void closeSquareBracket() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(93);
        this.newLine();
    }

    private void openRoundBracket() throws IOException {
        this.writer.write(40);
        this.newLine();
        this.increaseIndent();
    }

    private void closeRoundBracket() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(41);
        this.newLine();
    }

    private void newLine() throws IOException {
        this.writer.write(NEW_LINE);
    }

    private void indent() throws IOException {
        if (this.prettyPrint && this.indentString != null) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }

    private void increaseIndent() {
        if (this.prettyPrint) {
            ++this.indentDepth;
        }
    }

    private void decreaseIndent() {
        if (this.prettyPrint) {
            --this.indentDepth;
        }
    }

    private String readLine(String value, int start) {
        char c;
        int end;
        if (start >= value.length()) {
            return null;
        }
        for (end = start; end < value.length() && (c = value.charAt(end)) != '\n' && c != '\r'; ++end) {
        }
        return end > start ? value.substring(start, end) : "";
    }

    private int skipNewLineChar(String value, int start) {
        char c;
        int end;
        boolean cr = false;
        boolean lf = false;
        for (end = start; !(end >= value.length() || (c = value.charAt(end)) != '\n' && c != '\r' || lf && c == '\n' || cr && c == '\r'); ++end) {
            if (c == '\n') {
                lf = true;
            }
            if (c != '\r') continue;
            cr = true;
        }
        return end > start ? end : -1;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = null;
    }

    public static String stringify(Parameters parameters) {
        return AponWriter.stringify(parameters, "\t");
    }

    public static String stringify(Parameters parameters, boolean prettyPrint) {
        if (prettyPrint) {
            return AponWriter.stringify(parameters, "\t");
        }
        return AponWriter.stringify(parameters, null);
    }

    public static String stringify(Parameters parameters, String indentString) {
        if (parameters == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            AponWriter aponWriter = new AponWriter((Writer)writer, indentString);
            aponWriter.write(parameters);
            aponWriter.close();
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

