/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.ParameterValueType;

public class ParameterDefinition {
    private final String name;
    private final ParameterValueType parameterValueType;
    private final Class<? extends AbstractParameters> parametersClass;
    private final boolean array;
    private final boolean noBracket;

    public ParameterDefinition(String name, ParameterValueType parameterValueType) {
        this(name, parameterValueType, false);
    }

    public ParameterDefinition(String name, ParameterValueType parameterValueType, boolean array) {
        this(name, parameterValueType, array, false);
    }

    public ParameterDefinition(String name, ParameterValueType parameterValueType, boolean array, boolean noBracket) {
        this.name = name;
        this.parameterValueType = parameterValueType;
        this.parametersClass = null;
        this.array = array;
        this.noBracket = array && parameterValueType == ParameterValueType.PARAMETERS && noBracket;
    }

    public ParameterDefinition(String name, Class<? extends AbstractParameters> parametersClass) {
        this(name, parametersClass, false);
    }

    public ParameterDefinition(String name, Class<? extends AbstractParameters> parametersClass, boolean array) {
        this(name, parametersClass, array, false);
    }

    public ParameterDefinition(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBracket) {
        this.name = name;
        this.parameterValueType = ParameterValueType.PARAMETERS;
        this.parametersClass = parametersClass;
        this.array = array;
        this.noBracket = array && noBracket;
    }

    public String getName() {
        return this.name;
    }

    public ParameterValueType getParameterValueType() {
        return this.parameterValueType;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isNoBracket() {
        return this.noBracket;
    }

    public ParameterValue newParameterValue() {
        ParameterValue parameterValue = this.parameterValueType == ParameterValueType.PARAMETERS && this.parametersClass != null ? new ParameterValue(this.name, this.parametersClass, this.array, this.noBracket, true) : new ParameterValue(this.name, this.parameterValueType, this.array, this.noBracket, true);
        return parameterValue;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("parameterValueType", (Object)this.parameterValueType);
        tsb.append("parametersClass", this.parametersClass);
        tsb.append("array", this.array);
        return tsb.toString();
    }
}

