/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.IncompatibleParameterValueTypeException;
import com.aspectran.core.util.apon.InvalidParameterException;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterValueType;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.VariableParameters;
import java.util.ArrayList;
import java.util.List;

public class ParameterValue
implements Parameter {
    private Parameters container;
    private final String name;
    private final ParameterValueType originParameterValueType;
    private ParameterValueType parameterValueType;
    private boolean valueTypeHinted;
    private Class<? extends AbstractParameters> parametersClass;
    private boolean array;
    private boolean bracketed;
    private final boolean predefined;
    private volatile Object value;
    private List<Object> list;
    private boolean assigned;

    public ParameterValue(String name, ParameterValueType parameterValueType) {
        this(name, parameterValueType, false);
    }

    public ParameterValue(String name, ParameterValueType parameterValueType, boolean array) {
        this(name, parameterValueType, array, false);
    }

    public ParameterValue(String name, ParameterValueType parameterValueType, boolean array, boolean noBracket) {
        this(name, parameterValueType, array, noBracket, false);
    }

    protected ParameterValue(String name, ParameterValueType parameterValueType, boolean array, boolean noBracket, boolean predefined) {
        this.name = name;
        this.parameterValueType = parameterValueType;
        this.originParameterValueType = parameterValueType;
        this.array = array;
        boolean bl = this.predefined = predefined && parameterValueType != ParameterValueType.VARIABLE;
        if (this.array && !noBracket) {
            this.bracketed = true;
        }
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass) {
        this(name, parametersClass, false);
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array) {
        this(name, parametersClass, array, false);
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBracket) {
        this(name, parametersClass, array, noBracket, false);
    }

    protected ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBracket, boolean predefined) {
        this.name = name;
        this.originParameterValueType = this.parameterValueType = ParameterValueType.PARAMETERS;
        this.parametersClass = parametersClass;
        this.array = array;
        this.predefined = predefined;
        if (this.array && !noBracket) {
            this.bracketed = true;
        }
    }

    @Override
    public Parameters getContainer() {
        return this.container;
    }

    public void setContainer(Parameters container) {
        this.container = container;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        if (this.container == null) {
            return this.name;
        }
        Parameter prototype = this.container.getIdentifier();
        if (prototype != null) {
            return prototype.getQualifiedName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public ParameterValueType getParameterValueType() {
        return this.parameterValueType;
    }

    @Override
    public void setParameterValueType(ParameterValueType parameterValueType) {
        this.parameterValueType = parameterValueType;
    }

    @Override
    public boolean isValueTypeHinted() {
        return this.valueTypeHinted;
    }

    @Override
    public void setValueTypeHinted(boolean valueTypeHinted) {
        this.valueTypeHinted = valueTypeHinted;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isBracketed() {
        return this.bracketed;
    }

    public void setBracketed(boolean bracketed) {
        this.bracketed = bracketed;
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    @Override
    public boolean isAssigned() {
        return this.assigned;
    }

    @Override
    public boolean hasValue() {
        if (this.assigned) {
            if (this.array) {
                return this.list != null;
            }
            return this.value != null;
        }
        return false;
    }

    @Override
    public int getArraySize() {
        List<?> list = this.getValueList();
        return list != null ? list.size() : 0;
    }

    @Override
    public void arraylize() {
        if (this.assigned) {
            throw new IllegalStateException("This parameter can not be converted to an array type: it already has a value assigned to it");
        }
        this.array = true;
        this.bracketed = true;
    }

    @Override
    public void putValue(Object value) {
        if (!this.predefined && value != null) {
            if (this.parameterValueType == ParameterValueType.STRING) {
                if (value.toString().indexOf(10) != -1) {
                    this.parameterValueType = ParameterValueType.TEXT;
                }
            } else if (this.parameterValueType == ParameterValueType.VARIABLE && value instanceof String) {
                this.parameterValueType = value.toString().indexOf(10) != -1 ? ParameterValueType.TEXT : ParameterValueType.STRING;
            }
        }
        if (!this.predefined && !this.array && this.value != null) {
            this.addValue(this.value);
            this.addValue(value);
            this.value = null;
            this.array = true;
            this.bracketed = true;
        } else if (this.array) {
            this.addValue(value);
        } else {
            this.value = value;
            this.assigned = true;
        }
    }

    private synchronized void addValue(Object value) {
        if (this.list == null) {
            this.list = new ArrayList<Object>();
            this.assigned = true;
        }
        this.list.add(value);
    }

    @Override
    public void clearValue() {
        this.value = null;
        this.list = null;
        this.assigned = false;
        if (!this.predefined) {
            this.array = false;
            this.bracketed = false;
        }
    }

    @Override
    public Object getValue() {
        return this.array ? this.getValueList() : this.value;
    }

    @Override
    public List<?> getValueList() {
        if (!this.predefined && this.value != null && this.list == null && this.originParameterValueType == ParameterValueType.VARIABLE) {
            this.addValue(this.value);
        }
        return this.list;
    }

    @Override
    public Object[] getValues() {
        List<?> list = this.getValueList();
        return list != null ? list.toArray(new Object[0]) : null;
    }

    @Override
    public String getValueAsString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public String[] getValueAsStringArray() {
        if (this.array) {
            List<?> list = this.getValueList();
            if (list != null) {
                String[] s = new String[list.size()];
                for (int i = 0; i < s.length; ++i) {
                    s[i] = list.get(i).toString();
                }
                return s;
            }
            return null;
        }
        if (this.value != null) {
            return new String[]{this.value.toString()};
        }
        return null;
    }

    @Override
    public List<String> getValueAsStringList() {
        if (this.parameterValueType == ParameterValueType.STRING) {
            return this.getValueList();
        }
        List<?> list1 = this.getValueList();
        if (list1 != null) {
            ArrayList<String> list2 = new ArrayList<String>();
            for (Object o : list1) {
                list2.add(o.toString());
            }
            return list2;
        }
        return null;
    }

    @Override
    public Integer getValueAsInt() {
        this.checkParameterValueType(ParameterValueType.INT);
        return (Integer)this.value;
    }

    @Override
    public Integer[] getValueAsIntArray() {
        List<Integer> intList = this.getValueAsIntList();
        return intList != null ? intList.toArray(new Integer[0]) : null;
    }

    @Override
    public List<Integer> getValueAsIntList() {
        this.checkParameterValueType(ParameterValueType.INT);
        return this.getValueList();
    }

    @Override
    public Long getValueAsLong() {
        this.checkParameterValueType(ParameterValueType.LONG);
        return (Long)this.value;
    }

    @Override
    public Long[] getValueAsLongArray() {
        List<Long> longList = this.getValueAsLongList();
        return longList != null ? longList.toArray(new Long[0]) : null;
    }

    @Override
    public List<Long> getValueAsLongList() {
        this.checkParameterValueType(ParameterValueType.LONG);
        return this.getValueList();
    }

    @Override
    public Float getValueAsFloat() {
        this.checkParameterValueType(ParameterValueType.FLOAT);
        return (Float)this.value;
    }

    @Override
    public Float[] getValueAsFloatArray() {
        List<Float> floatList = this.getValueAsFloatList();
        return floatList != null ? floatList.toArray(new Float[0]) : null;
    }

    @Override
    public List<Float> getValueAsFloatList() {
        this.checkParameterValueType(ParameterValueType.FLOAT);
        return this.getValueList();
    }

    @Override
    public Double getValueAsDouble() {
        this.checkParameterValueType(ParameterValueType.DOUBLE);
        return (Double)this.value;
    }

    @Override
    public Double[] getValueAsDoubleArray() {
        List<Double> doubleList = this.getValueAsDoubleList();
        return doubleList != null ? doubleList.toArray(new Double[0]) : null;
    }

    @Override
    public List<Double> getValueAsDoubleList() {
        this.checkParameterValueType(ParameterValueType.DOUBLE);
        return this.getValueList();
    }

    @Override
    public Boolean getValueAsBoolean() {
        this.checkParameterValueType(ParameterValueType.BOOLEAN);
        return (Boolean)this.value;
    }

    @Override
    public Boolean[] getValueAsBooleanArray() {
        List<Boolean> booleanList = this.getValueAsBooleanList();
        return booleanList != null ? booleanList.toArray(new Boolean[0]) : null;
    }

    @Override
    public List<Boolean> getValueAsBooleanList() {
        this.checkParameterValueType(ParameterValueType.BOOLEAN);
        return this.getValueList();
    }

    @Override
    public Parameters getValueAsParameters() {
        this.checkParameterValueType(ParameterValueType.PARAMETERS);
        return (Parameters)this.value;
    }

    @Override
    public Parameters[] getValueAsParametersArray() {
        List<Parameters> parametersList = this.getValueAsParametersList();
        return parametersList != null ? parametersList.toArray(new Parameters[0]) : null;
    }

    @Override
    public List<Parameters> getValueAsParametersList() {
        if (this.parameterValueType != ParameterValueType.PARAMETERS) {
            throw new IncompatibleParameterValueTypeException(this, ParameterValueType.PARAMETERS);
        }
        return this.getValueList();
    }

    @Override
    public Parameters newParameters(Parameter identifier) {
        if (this.parameterValueType == ParameterValueType.VARIABLE) {
            this.parameterValueType = ParameterValueType.PARAMETERS;
            this.parametersClass = VariableParameters.class;
        } else {
            this.checkParameterValueType(ParameterValueType.PARAMETERS);
            if (this.parametersClass == null) {
                this.parametersClass = VariableParameters.class;
            }
        }
        try {
            Parameters p = ClassUtils.createInstance(this.parametersClass);
            p.setIdentifier(identifier);
            this.putValue(p);
            return p;
        }
        catch (Exception e) {
            throw new InvalidParameterException("Could not instantiate Parameters: " + this.parametersClass, e);
        }
    }

    private void checkParameterValueType(ParameterValueType parameterValueType) {
        if (this.parameterValueType != ParameterValueType.VARIABLE && this.parameterValueType != parameterValueType) {
            throw new IncompatibleParameterValueTypeException(this, parameterValueType);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("parameterValueType", (Object)this.parameterValueType);
        if (this.parameterValueType == ParameterValueType.PARAMETERS) {
            tsb.append("parametersClass", this.parametersClass);
        }
        tsb.append("array", this.array);
        tsb.append("bracketed", this.bracketed);
        if (this.array) {
            tsb.append("arraySize", this.getArraySize());
        }
        tsb.append("qualifiedName", this.getQualifiedName());
        return tsb.toString();
    }
}

