/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.apon.Parameters;

public enum ParameterValueType {
    STRING("string"),
    TEXT("text"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    BOOLEAN("boolean"),
    VARIABLE("variable"),
    PARAMETERS("parameters");

    private final String alias;

    private ParameterValueType(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    public static ParameterValueType resolve(String alias) {
        for (ParameterValueType type : ParameterValueType.values()) {
            if (!type.alias.equals(alias)) continue;
            return type;
        }
        return null;
    }

    public static ParameterValueType resolveByHint(String name) {
        int hintEndIndex;
        int hintStartIndex = name.indexOf(40);
        if (hintStartIndex > 0 && (hintEndIndex = name.indexOf(41)) > hintStartIndex) {
            String typeHint = name.substring(hintStartIndex + 1, hintEndIndex);
            return ParameterValueType.resolve(typeHint);
        }
        return null;
    }

    public static String stripValueTypeHint(String name) {
        int hintStartIndex = name.indexOf(40);
        if (hintStartIndex > 0) {
            return name.substring(0, hintStartIndex);
        }
        return name;
    }

    public static ParameterValueType determineValueType(Object value) {
        ParameterValueType type = value instanceof String ? (value.toString().indexOf(10) == -1 ? STRING : TEXT) : (value instanceof Integer ? INT : (value instanceof Long ? LONG : (value instanceof Float ? FLOAT : (value instanceof Double ? DOUBLE : (value instanceof Boolean ? BOOLEAN : (value instanceof Parameters ? PARAMETERS : STRING))))));
        return type;
    }
}

