/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.json;

import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.Parameters;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JsonWriter
implements Flushable {
    private static final String DEFAULT_INDENT_STRING = "\t";
    private Writer writer;
    private boolean prettyPrint;
    private String indentString;
    private int indentDepth;
    private boolean willWriteValue;

    public JsonWriter(Writer writer) {
        this(writer, false);
    }

    public JsonWriter(Writer writer, boolean prettyPrint) {
        this.writer = writer;
        this.prettyPrint = prettyPrint;
        this.indentString = prettyPrint ? DEFAULT_INDENT_STRING : null;
    }

    public JsonWriter(Writer writer, String indentString) {
        this.writer = writer;
        this.prettyPrint = indentString != null;
        this.indentString = indentString;
    }

    public JsonWriter write(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String || object instanceof Date) {
            this.writeValue(object.toString());
        } else if (object instanceof Boolean) {
            this.writeValue((Boolean)object);
        } else if (object instanceof Number) {
            this.writeValue((Number)object);
        } else if (object instanceof Parameters) {
            this.openCurlyBracket();
            Map<String, ParameterValue> params = ((Parameters)object).getParameterValueMap();
            Iterator<ParameterValue> it = params.values().iterator();
            while (it.hasNext()) {
                Parameter p = it.next();
                String name = p.getName();
                Object value = p.getValue();
                this.checkCircularReference(object, value);
                this.writeName(name);
                this.write(value);
                if (!it.hasNext()) continue;
                this.writeComma();
            }
            this.closeCurlyBracket();
        } else if (object instanceof Map) {
            this.openCurlyBracket();
            Iterator it = ((Map)object).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                this.checkCircularReference(object, value);
                this.writeName(name);
                this.write(value);
                if (!it.hasNext()) continue;
                this.writeComma();
            }
            this.closeCurlyBracket();
        } else if (object instanceof Collection) {
            this.openSquareBracket();
            Iterator it = ((Collection)object).iterator();
            while (it.hasNext()) {
                Object value = it.next();
                this.checkCircularReference(object, value);
                this.write(value);
                if (!it.hasNext()) continue;
                this.writeComma();
            }
            this.closeSquareBracket();
        } else if (object.getClass().isArray()) {
            this.openSquareBracket();
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(object, i);
                this.checkCircularReference(object, value);
                if (i > 0) {
                    this.writeComma();
                }
                this.write(value);
            }
            this.closeSquareBracket();
        } else {
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames != null && readablePropertyNames.length > 0) {
                this.openCurlyBracket();
                for (int i = 0; i < readablePropertyNames.length; ++i) {
                    Object value;
                    try {
                        value = BeanUtils.getProperty(object, readablePropertyNames[i]);
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException(e);
                    }
                    this.checkCircularReference(object, value);
                    this.writeName(readablePropertyNames[i]);
                    this.write(value);
                    if (i >= readablePropertyNames.length - 1) continue;
                    this.writeComma();
                }
                this.closeCurlyBracket();
            } else {
                this.writeValue(object.toString());
            }
        }
        return this;
    }

    private void checkCircularReference(Object wrapper, Object member) throws IOException {
        if (wrapper.equals(member)) {
            throw new IOException("JSON Serialization Failure: A circular reference was detected while converting a member object [" + member + "] in [" + wrapper + "]");
        }
    }

    protected void indent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }

    public JsonWriter writeName(String name) throws IOException {
        this.indent();
        this.writer.write(JsonWriter.escape(name));
        this.writer.write(":");
        if (this.prettyPrint) {
            this.writer.write(" ");
        }
        this.willWriteValue = true;
        return this;
    }

    public JsonWriter writeValue(String value) throws IOException {
        if (!this.willWriteValue) {
            this.indent();
        }
        this.writer.write(JsonWriter.escape(value));
        this.willWriteValue = false;
        return this;
    }

    public JsonWriter writeValue(Boolean value) throws IOException {
        if (!this.willWriteValue) {
            this.indent();
        }
        this.writer.write(value.toString());
        this.willWriteValue = false;
        return this;
    }

    public JsonWriter writeValue(Number value) throws IOException {
        if (!this.willWriteValue) {
            this.indent();
        }
        this.writer.write(value.toString());
        this.willWriteValue = false;
        return this;
    }

    public JsonWriter writeNull() throws IOException {
        this.writer.write("null");
        return this;
    }

    public JsonWriter writeComma() throws IOException {
        this.writer.write(",");
        if (this.prettyPrint) {
            this.writer.write(" ");
        }
        this.nextLine();
        return this;
    }

    protected void nextLine() throws IOException {
        if (this.prettyPrint) {
            this.writer.write("\n");
        }
    }

    public JsonWriter openCurlyBracket() throws IOException {
        if (!this.willWriteValue) {
            this.indent();
        }
        this.writer.write("{");
        this.nextLine();
        ++this.indentDepth;
        return this;
    }

    public JsonWriter closeCurlyBracket() throws IOException {
        --this.indentDepth;
        this.nextLine();
        this.indent();
        this.writer.write("}");
        return this;
    }

    public JsonWriter openSquareBracket() throws IOException {
        if (!this.willWriteValue) {
            this.indent();
        }
        this.writer.write("[");
        this.nextLine();
        ++this.indentDepth;
        this.willWriteValue = false;
        return this;
    }

    public JsonWriter closeSquareBracket() throws IOException {
        --this.indentDepth;
        this.nextLine();
        this.indent();
        this.writer.write("]");
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private static String escape(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        char c = '\u0000';
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String stringify(Object object) throws IOException {
        return JsonWriter.stringify(object, null);
    }

    public static String stringify(Object object, boolean prettyPrint) throws IOException {
        if (prettyPrint) {
            return JsonWriter.stringify(object, DEFAULT_INDENT_STRING);
        }
        return JsonWriter.stringify(object, null);
    }

    public static String stringify(Object object, String indentString) throws IOException {
        if (object == null) {
            return null;
        }
        StringWriter out = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)out, indentString);
        jsonWriter.write(object);
        jsonWriter.close();
        return ((Object)out).toString();
    }
}

