/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.logging;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogException;
import com.aspectran.core.util.logging.commons.JakartaCommonsLoggingImpl;
import com.aspectran.core.util.logging.jdk14.Jdk14LoggingImpl;
import com.aspectran.core.util.logging.log4j.Log4jImpl;
import com.aspectran.core.util.logging.log4j2.Log4j2Impl;
import com.aspectran.core.util.logging.nologging.NoLoggingImpl;
import com.aspectran.core.util.logging.slf4j.Slf4jImpl;
import com.aspectran.core.util.logging.stdout.StdOutImpl;
import java.lang.reflect.Constructor;

public final class LogFactory {
    public static final String MARKER = "ASPECTRAN";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> aClass) {
        return LogFactory.getLog(aClass.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    @Deprecated
    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation(Log4jImpl.class);
    }

    public static synchronized void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Log> implClass) {
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation", t);
        }
    }

    static {
        LogFactory.tryImplementation(LogFactory::useSlf4jLogging);
        LogFactory.tryImplementation(LogFactory::useCommonsLogging);
        LogFactory.tryImplementation(LogFactory::useLog4J2Logging);
        LogFactory.tryImplementation(LogFactory::useLog4JLogging);
        LogFactory.tryImplementation(LogFactory::useJdkLogging);
        LogFactory.tryImplementation(LogFactory::useNoLogging);
    }
}

