/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.thread;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class IdleTimeout {
    private static final Log log = LogFactory.getLog(IdleTimeout.class);
    private final AtomicReference<Scheduler.Task> timeout = new AtomicReference();
    private final Scheduler scheduler;
    private volatile long idleTimeout;
    private volatile long idleTimestamp = System.currentTimeMillis();
    private final Runnable idleTask = () -> {
        long idleLeft = this.checkIdleTimeout();
        if (idleLeft >= 0L) {
            this.scheduleIdleTimeout(idleLeft > 0L ? idleLeft : this.getIdleTimeout());
        }
    };

    public IdleTimeout(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        long old = this.idleTimeout;
        this.idleTimeout = idleTimeout;
        if (old > 0L) {
            if (old <= idleTimeout) {
                return;
            }
            this.deactivate();
        }
        if (this.isValid()) {
            this.activate();
        }
    }

    public void notIdle() {
        this.idleTimestamp = System.currentTimeMillis();
    }

    private void activate() {
        if (this.idleTimeout > 0L) {
            this.idleTask.run();
        }
    }

    private void deactivate() {
        Scheduler.Task oldTimeout = this.timeout.getAndSet(null);
        if (oldTimeout != null) {
            oldTimeout.cancel();
        }
    }

    private void scheduleIdleTimeout(long delay) {
        Scheduler.Task oldTimeout;
        Scheduler.Task newTimeout = null;
        if (this.isValid() && delay > 0L) {
            newTimeout = this.scheduler.schedule(this.idleTask, delay, TimeUnit.MILLISECONDS);
        }
        if ((oldTimeout = (Scheduler.Task)this.timeout.getAndSet(newTimeout)) != null) {
            oldTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkIdleTimeout() {
        if (!this.isValid()) {
            return -1L;
        }
        long idleTimestamp = this.idleTimestamp;
        long idleTimeout = this.idleTimeout;
        long idleElapsed = System.currentTimeMillis() - idleTimestamp;
        long idleLeft = idleTimeout - idleElapsed;
        if (log.isTraceEnabled()) {
            log.trace(this + " idle timeout check, elapsed: " + idleElapsed + " ms, remaining: " + idleLeft + " ms");
        }
        if (idleTimestamp != 0L && idleTimeout > 0L && idleLeft <= 0L) {
            try {
                this.idleExpired();
            }
            finally {
                this.notIdle();
            }
        }
        return idleLeft >= 0L ? idleLeft : 0L;
    }

    public abstract boolean isValid();

    protected abstract void idleExpired();
}

