/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.thread;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Locker {
    private static final Lock LOCKED = new Lock();
    private final ReentrantLock lock = new ReentrantLock();
    private final Lock unlock = new UnLock();

    public Lock lock() {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Locker is not reentrant");
        }
        this.lock.lock();
        return this.unlock;
    }

    public Lock lockIfNotHeld() {
        if (this.lock.isHeldByCurrentThread()) {
            return LOCKED;
        }
        this.lock.lock();
        return this.unlock;
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public Condition newCondition() {
        return this.lock.newCondition();
    }

    public class UnLock
    extends Lock {
        @Override
        public void close() {
            Locker.this.lock.unlock();
        }
    }

    public static class Lock
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }
}

