/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.thread;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Scheduler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScheduledExecutorScheduler
implements Scheduler {
    private static final Log log = LogFactory.getLog(ScheduledExecutorScheduler.class);
    private final AtomicBoolean active = new AtomicBoolean();
    private volatile ScheduledThreadPoolExecutor executor;

    @Override
    public void start() {
        if (this.active.compareAndSet(false, true)) {
            if (log.isDebugEnabled()) {
                log.debug("Starting " + this);
            }
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.setRemoveOnCancelPolicy(true);
        } else if (log.isDebugEnabled()) {
            log.warn("Already Started " + this);
        }
    }

    @Override
    public void stop() {
        if (this.active.compareAndSet(true, false)) {
            if (log.isDebugEnabled()) {
                log.debug("Stopping " + this);
            }
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledThreadPoolExecutor executor = this.executor;
        if (executor == null) {
            return () -> false;
        }
        ScheduledFuture<?> result = executor.schedule(task, delay, unit);
        return new ScheduledFutureTask(result);
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

