/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.thread;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShutdownHooks {
    private static final Log log = LogFactory.getLog(ShutdownHooks.class);
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;

    public static synchronized <T extends Task> T add(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (hook == null) {
            hook = ShutdownHooks.addHook(new Thread("ShutdownHook"){

                @Override
                public void run() {
                    ShutdownHooks.runTasks();
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding shutdown-hook task: " + task);
        }
        tasks.add(task);
        return task;
    }

    public static synchronized void remove(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (hook == null) {
            return;
        }
        tasks.remove(task);
        if (tasks.isEmpty()) {
            ShutdownHooks.removeHook(hook);
            hook = null;
        }
    }

    private static Thread addHook(Thread thread) {
        block3: {
            if (log.isDebugEnabled()) {
                log.debug("Registering shutdown-hook: " + thread);
            }
            try {
                Runtime.getRuntime().addShutdownHook(thread);
            }
            catch (AbstractMethodError e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("Failed to register shutdown-hook: " + e);
            }
        }
        return thread;
    }

    private static void removeHook(Thread thread) {
        if (log.isDebugEnabled()) {
            log.debug("Removing shutdown-hook: " + thread);
        }
        try {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (AbstractMethodError e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to register shutdown-hook: " + e);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static synchronized void runTasks() {
        if (log.isDebugEnabled()) {
            log.debug("Running all shutdown-hook tasks");
        }
        Collections.reverse(tasks);
        for (Task task : tasks.toArray(new Task[0])) {
            if (log.isDebugEnabled()) {
                log.debug("Running task: " + task);
            }
            try {
                task.run();
            }
            catch (Throwable e) {
                log.warn("Task failed", e);
            }
        }
        tasks.clear();
    }

    public static interface Task {
        public void run() throws Exception;
    }
}

