/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.wildcard;

import com.aspectran.core.util.wildcard.WildcardPattern;
import java.util.ArrayList;

public class PluralWildcardPattern {
    private final WildcardPattern[] includePatterns;
    private final WildcardPattern[] excludePatterns;

    public PluralWildcardPattern(WildcardPattern[] includePatterns, WildcardPattern[] excludePatterns) {
        this.includePatterns = includePatterns;
        this.excludePatterns = excludePatterns;
    }

    public PluralWildcardPattern(String[] includePatterns, String[] excludePatterns) {
        this.includePatterns = PluralWildcardPattern.compile(includePatterns);
        this.excludePatterns = PluralWildcardPattern.compile(excludePatterns);
    }

    public PluralWildcardPattern(String[] includePatterns, String[] excludePatterns, char separator) {
        this.includePatterns = PluralWildcardPattern.compile(includePatterns, separator);
        this.excludePatterns = PluralWildcardPattern.compile(excludePatterns, separator);
    }

    public boolean matches(String compareString) {
        boolean result = false;
        if (this.includePatterns != null) {
            for (WildcardPattern pattern : this.includePatterns) {
                if (!pattern.matches(compareString)) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        if (result && this.excludePatterns != null) {
            for (WildcardPattern pattern : this.excludePatterns) {
                if (!pattern.matches(compareString)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static WildcardPattern[] compile(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        ArrayList<WildcardPattern> wildcardPatternList = new ArrayList<WildcardPattern>(patterns.length);
        for (String pattern : patterns) {
            if (pattern == null || pattern.length() <= 0) continue;
            WildcardPattern wildcardPattern = new WildcardPattern(pattern);
            wildcardPatternList.add(wildcardPattern);
        }
        if (wildcardPatternList.size() > 0) {
            return wildcardPatternList.toArray(new WildcardPattern[0]);
        }
        return null;
    }

    public static WildcardPattern[] compile(String[] patterns, char separator) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        ArrayList<WildcardPattern> wildcardPatternList = new ArrayList<WildcardPattern>(patterns.length);
        for (String pattern : patterns) {
            if (pattern == null || pattern.length() <= 0) continue;
            WildcardPattern wildcardPattern = new WildcardPattern(pattern, separator);
            wildcardPatternList.add(wildcardPattern);
        }
        if (wildcardPatternList.size() > 0) {
            return wildcardPatternList.toArray(new WildcardPattern[0]);
        }
        return null;
    }
}

