/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.wildcard;

import com.aspectran.core.util.wildcard.WildcardPattern;

public class WildcardMatcher {
    private WildcardPattern pattern;
    private CharSequence input;
    private int[] separatorFlags;
    private int separatorCount = -1;
    private int separatorIndex;

    public WildcardMatcher(WildcardPattern pattern) {
        this.pattern = pattern;
    }

    public boolean matches(CharSequence input) {
        this.separatorCount = -1;
        this.separatorIndex = 0;
        if (input == null) {
            this.input = null;
            this.separatorFlags = null;
            return false;
        }
        this.input = input;
        this.separatorFlags = new int[input.length()];
        boolean result = WildcardMatcher.matches(this.pattern, input, this.separatorFlags);
        if (result) {
            for (int i = this.separatorFlags.length - 1; i >= 0; --i) {
                if (this.separatorFlags[i] <= 0) continue;
                this.separatorCount = this.separatorFlags[i];
                break;
            }
        }
        return result;
    }

    public int separate(CharSequence input) {
        this.separatorCount = -1;
        this.separatorIndex = 0;
        if (input == null) {
            this.input = null;
            this.separatorFlags = null;
            return 0;
        }
        this.input = input;
        int len = input.length();
        char separator = this.pattern.getSeparator();
        this.separatorFlags = new int[len];
        for (int i = 0; i < len; ++i) {
            if (input.charAt(i) != separator) continue;
            this.separatorFlags[i] = ++this.separatorCount;
        }
        return this.separatorCount;
    }

    public WildcardMatcher first() {
        this.separatorIndex = 0;
        return this;
    }

    public WildcardMatcher last() {
        if (this.separatorCount > -1) {
            this.separatorIndex = this.separatorCount;
        }
        return this;
    }

    public boolean hasNext() {
        return this.separatorIndex <= this.separatorCount;
    }

    public boolean hasPrev() {
        return this.separatorIndex >= 0;
    }

    public String next() {
        if (this.separatorIndex > this.separatorCount) {
            return null;
        }
        return this.find(this.separatorIndex++);
    }

    public String previous() {
        if (this.separatorIndex < 0) {
            return null;
        }
        return this.find(this.separatorIndex--);
    }

    public String find() {
        return this.find(this.separatorIndex);
    }

    public String find(int group) {
        if (this.separatorCount == 0) {
            if (this.input == null) {
                return null;
            }
            return this.input.toString();
        }
        if (group < 0 || group > this.separatorCount) {
            throw new IndexOutOfBoundsException();
        }
        int start = 0;
        int offset = -1;
        if (group == 0) {
            for (int i = 0; i < this.separatorFlags.length; ++i) {
                if (this.separatorFlags[i] != 1) continue;
                offset = i;
                break;
            }
            if (offset == -1) {
                offset = this.separatorFlags.length;
            }
        } else {
            for (int i = 0; i < this.separatorFlags.length; ++i) {
                if (this.separatorFlags[i] == group) {
                    start = i + 1;
                    continue;
                }
                if (start <= 0 || this.separatorFlags[i] != group + 1) continue;
                offset = i;
                break;
            }
            if (start > 0 && offset == -1) {
                offset = this.separatorFlags.length;
            }
        }
        if (offset == -1) {
            return null;
        }
        if (offset == 0) {
            return "";
        }
        return this.input.subSequence(start, offset).toString();
    }

    public int getSeparatorCount() {
        return this.separatorCount;
    }

    public WildcardPattern getWildcardPattern() {
        return this.pattern;
    }

    public static boolean matches(WildcardPattern pattern, CharSequence input) {
        return WildcardMatcher.matches(pattern, input, null);
    }

    private static boolean matches(WildcardPattern pattern, CharSequence input, int[] separatorFlags) {
        int ttmp;
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        char[] tokens = pattern.getTokens();
        int[] types = pattern.getTypes();
        char sepa = pattern.getSeparator();
        int tlen = tokens.length;
        int clen = input.length();
        int sepaCnt = 0;
        int tidx = 0;
        int cidx = 0;
        while (tidx < tlen && cidx < clen) {
            int trng2;
            int trng1;
            if (types[tidx] == 1) {
                if (tokens[tidx++] == input.charAt(cidx++)) continue;
                return false;
            }
            if (types[tidx] == 2) {
                trng1 = tidx + 1;
                if (trng1 < tlen) {
                    for (trng2 = trng1; trng2 < tlen && types[trng2] != 0 && types[trng2] == 1; ++trng2) {
                    }
                    if (trng1 == trng2) {
                        while (cidx < clen && input.charAt(cidx) != sepa) {
                            ++cidx;
                        }
                        ++tidx;
                        continue;
                    }
                    ttmp = trng1;
                    do {
                        if (input.charAt(cidx) == sepa) {
                            return false;
                        }
                        if (tokens[ttmp] != input.charAt(cidx++)) {
                            ttmp = trng1;
                            continue;
                        }
                        ++ttmp;
                    } while (ttmp < trng2 && cidx < clen);
                    if (ttmp < trng2) {
                        return false;
                    }
                    tidx = trng2;
                    continue;
                }
                while (cidx < clen && input.charAt(cidx) != sepa) {
                    ++cidx;
                }
                ++tidx;
                continue;
            }
            if (types[tidx] == 3) {
                if (sepa > '\u0000') {
                    int crng2;
                    int crng1;
                    trng1 = -1;
                    trng2 = -1;
                    for (ttmp = tidx + 1; ttmp < tlen; ++ttmp) {
                        if (trng1 == -1) {
                            if (types[ttmp] != 1) continue;
                            trng1 = ttmp;
                            continue;
                        }
                        if (types[ttmp] == 1) continue;
                        trng2 = ttmp - 1;
                        break;
                    }
                    if (trng1 > -1 && trng2 > -1) {
                        crng1 = cidx;
                        crng2 = cidx;
                        ttmp = trng1;
                        while (ttmp <= trng2 && crng2 < clen) {
                            if (input.charAt(crng2++) != tokens[ttmp]) {
                                ttmp = trng1;
                                continue;
                            }
                            ++ttmp;
                        }
                        if (ttmp <= trng2) {
                            tidx = trng2;
                            if (cidx <= 0) continue;
                            --cidx;
                            continue;
                        }
                        if (separatorFlags != null && crng1 < crng2) {
                            for (int ctmp = crng1; ctmp < crng2; ++ctmp) {
                                if (input.charAt(ctmp) != sepa) continue;
                                separatorFlags[ctmp] = ++sepaCnt;
                            }
                        }
                        cidx = crng2;
                        tidx = trng2 + 1;
                        continue;
                    }
                    int scnt1 = 0;
                    for (ttmp = ++tidx; ttmp < tlen; ++ttmp) {
                        if (types[ttmp] != 9) continue;
                        ++scnt1;
                    }
                    if (scnt1 > 0) {
                        crng1 = cidx;
                        crng2 = clen;
                        int scnt2 = 0;
                        while (crng2 > 0 && crng1 <= crng2--) {
                            if (input.charAt(crng2) == sepa) {
                                ++scnt2;
                            }
                            if (scnt1 != scnt2) continue;
                        }
                        if (scnt1 != scnt2) continue;
                        cidx = crng2;
                        if (separatorFlags == null) continue;
                        while (crng1 < crng2) {
                            if (input.charAt(crng1) == sepa) {
                                separatorFlags[crng1] = ++sepaCnt;
                            }
                            ++crng1;
                        }
                        continue;
                    }
                    cidx = clen;
                    continue;
                }
                cidx = clen;
                ++tidx;
                continue;
            }
            if (types[tidx] == 4) {
                if (tidx > tlen - 1 || types[tidx + 1] != 1 || tokens[tidx + 1] != input.charAt(cidx)) {
                    if (sepa > '\u0000') {
                        if (input.charAt(cidx) != sepa) {
                            ++cidx;
                        }
                    } else {
                        ++cidx;
                    }
                }
                ++tidx;
                continue;
            }
            if (types[tidx] == 5) {
                if (sepa > '\u0000' && input.charAt(cidx) == sepa) {
                    return false;
                }
                ++cidx;
                ++tidx;
                continue;
            }
            if (types[tidx] == 9) {
                if (tokens[tidx++] != input.charAt(cidx++)) {
                    return false;
                }
                if (separatorFlags == null) continue;
                separatorFlags[cidx - 1] = ++sepaCnt;
                continue;
            }
            if (types[tidx] == 0) break;
            ++tidx;
        }
        if (cidx < clen) {
            return false;
        }
        if (tidx < tlen) {
            for (ttmp = tidx; ttmp < tlen; ++ttmp) {
                if (types[ttmp] != 1 && types[ttmp] != 5 && types[ttmp] != 9) continue;
                return false;
            }
        }
        return true;
    }
}

