/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.scheduler.service;

import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.type.TriggerType;
import com.aspectran.core.service.AbstractServiceController;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.wildcard.PluralWildcardPattern;
import com.aspectran.scheduler.service.ActivityLauncherJob;
import com.aspectran.scheduler.service.QuartzJobListener;
import com.aspectran.scheduler.service.SchedulerService;
import com.aspectran.scheduler.service.SchedulerServiceException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzSchedulerService
extends AbstractServiceController
implements SchedulerService {
    private static final Log log = LogFactory.getLog(QuartzSchedulerService.class);
    static final String SERVICE_DATA_KEY = "SERVICE";
    static final String JOB_RULE_DATA_KEY = "JOB_RULE";
    private final Set<Scheduler> schedulerSet = new HashSet<Scheduler>();
    private final Map<String, Scheduler> schedulerMap = new HashMap<String, Scheduler>();
    private final CoreService coreService;
    private int startDelaySeconds = 0;
    private boolean waitOnShutdown = false;
    private PluralWildcardPattern exposableTransletNamesPattern;

    public QuartzSchedulerService(CoreService coreService) {
        super(false);
        this.coreService = coreService;
    }

    @Override
    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    @Override
    public void setStartDelaySeconds(int startDelaySeconds) {
        this.startDelaySeconds = startDelaySeconds;
    }

    @Override
    public boolean isWaitOnShutdown() {
        return this.waitOnShutdown;
    }

    @Override
    public void setWaitOnShutdown(boolean waitOnShutdown) {
        this.waitOnShutdown = waitOnShutdown;
    }

    @Override
    public void setExposals(String[] includePatterns, String[] excludePatterns) {
        if (includePatterns != null && includePatterns.length > 0 || excludePatterns != null && excludePatterns.length > 0) {
            this.exposableTransletNamesPattern = new PluralWildcardPattern(includePatterns, excludePatterns, '/');
        }
    }

    private boolean isExposable(String transletName) {
        return this.exposableTransletNamesPattern == null || this.exposableTransletNamesPattern.matches(transletName);
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        this.startSchedulerService();
    }

    @Override
    protected void doPause() throws Exception {
        try {
            for (Scheduler scheduler : this.schedulerSet) {
                scheduler.pauseAll();
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not pause all schedulers", e);
        }
    }

    @Override
    protected void doPause(long timeout) throws Exception {
        log.warn(this.getServiceName() + " does not support pausing for a certain period of time");
    }

    @Override
    protected void doResume() throws Exception {
        try {
            for (Scheduler scheduler : this.schedulerSet) {
                scheduler.resumeAll();
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not resume all schedulers", e);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.stopSchedulerService();
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.coreService.getActivityContext();
    }

    private void startSchedulerService() throws SchedulerServiceException {
        ScheduleRuleRegistry scheduleRuleRegistry = this.getActivityContext().getScheduleRuleRegistry();
        if (scheduleRuleRegistry == null) {
            return;
        }
        Collection<ScheduleRule> scheduleRules = scheduleRuleRegistry.getScheduleRules();
        if (scheduleRules == null || scheduleRules.isEmpty()) {
            return;
        }
        log.info("Now try to starting QuartzSchedulerService");
        try {
            for (ScheduleRule scheduleRule : scheduleRules) {
                Scheduler scheduler = this.buildScheduler(scheduleRule);
                this.schedulerSet.add(scheduler);
                this.schedulerMap.put(scheduleRule.getId(), scheduler);
            }
            for (Scheduler scheduler : this.schedulerSet) {
                log.info("Starting scheduler '" + scheduler.getSchedulerName() + "'");
                QuartzJobListener defaultJobListener = new QuartzJobListener();
                scheduler.getListenerManager().addJobListener((JobListener)defaultJobListener);
                if (this.startDelaySeconds > 0) {
                    scheduler.startDelayed(this.startDelaySeconds);
                    continue;
                }
                scheduler.start();
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not start QuartzSchedulerService", e);
        }
    }

    private void stopSchedulerService() throws SchedulerServiceException {
        log.info("Now try to shutting down QuartzSchedulerService");
        try {
            for (Scheduler scheduler : this.schedulerSet) {
                if (scheduler.isShutdown()) continue;
                log.info("Shutting down the scheduler '" + scheduler.getSchedulerName() + "' with waitForJobsToComplete=" + this.waitOnShutdown);
                scheduler.shutdown(this.waitOnShutdown);
            }
            this.schedulerSet.clear();
            this.schedulerMap.clear();
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not shutdown QuartzSchedulerService", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String scheduleId) throws SchedulerServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Scheduler scheduler = this.getScheduler(scheduleId);
                if (scheduler != null && scheduler.isStarted()) {
                    scheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)scheduleId));
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not pause scheduler '" + scheduleId + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume(String scheduleId) throws SchedulerServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Scheduler scheduler = this.getScheduler(scheduleId);
                if (scheduler != null && scheduler.isStarted()) {
                    scheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)scheduleId));
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not resume scheduler '" + scheduleId + "'", e);
            }
        }
    }

    private Scheduler getScheduler(String scheduleId) {
        return this.schedulerMap.get(scheduleId);
    }

    private Scheduler buildScheduler(ScheduleRule scheduleRule) throws SchedulerException {
        Scheduler scheduler = null;
        if (scheduleRule.getSchedulerBeanClass() != null) {
            scheduler = (Scheduler)this.getActivityContext().getBeanRegistry().getBean(scheduleRule.getSchedulerBeanClass());
        } else if (scheduleRule.getSchedulerBeanId() != null) {
            scheduler = (Scheduler)this.getActivityContext().getBeanRegistry().getBean(scheduleRule.getSchedulerBeanId());
        }
        if (scheduler == null) {
            throw new SchedulerServiceException("No such scheduler bean; Invalid ScheduleRule " + scheduleRule);
        }
        List<ScheduledJobRule> jobRuleList = scheduleRule.getScheduledJobRuleList();
        for (ScheduledJobRule jobRule : jobRuleList) {
            if (this.isExposable(jobRule.getTransletName())) {
                JobDetail jobDetail = this.buildJobDetail(jobRule);
                if (jobDetail == null) continue;
                String triggerName = jobDetail.getKey().getName();
                String triggerGroup = scheduleRule.getId();
                Trigger trigger = this.buildTrigger(triggerName, triggerGroup, scheduleRule);
                scheduler.scheduleJob(jobDetail, trigger);
                continue;
            }
            log.warn("Unexposable translet [" + jobRule.getTransletName() + "] in ScheduleRule " + scheduleRule);
        }
        return scheduler;
    }

    private JobDetail buildJobDetail(ScheduledJobRule jobRule) {
        String jobName = jobRule.getTransletName();
        String jobGroup = jobRule.getScheduleRule().getId();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(SERVICE_DATA_KEY, (Object)this);
        jobDataMap.put(JOB_RULE_DATA_KEY, (Object)jobRule);
        return JobBuilder.newJob(ActivityLauncherJob.class).withIdentity(jobName, jobGroup).setJobData(jobDataMap).build();
    }

    private Trigger buildTrigger(String name, String group, ScheduleRule scheduleRule) {
        TriggerParameters triggerParameters = scheduleRule.getTriggerParameters();
        Integer triggerStartDelaySeconds = triggerParameters.getInt(TriggerParameters.startDelaySeconds);
        int intTriggerStartDelaySeconds = triggerStartDelaySeconds != null ? triggerStartDelaySeconds : 0;
        Date firstFireTime = this.startDelaySeconds > 0 || triggerStartDelaySeconds != null && triggerStartDelaySeconds > 0 ? new Date(System.currentTimeMillis() + (long)(this.startDelaySeconds + intTriggerStartDelaySeconds) * 1000L) : new Date();
        if (scheduleRule.getTriggerType() == TriggerType.SIMPLE) {
            Long intervalInMilliseconds = triggerParameters.getLong(TriggerParameters.intervalInMilliseconds);
            Integer intervalInSeconds = triggerParameters.getInt(TriggerParameters.intervalInSeconds);
            Integer intervalInMinutes = triggerParameters.getInt(TriggerParameters.intervalInMinutes);
            Integer intervalInHours = triggerParameters.getInt(TriggerParameters.intervalInHours);
            Integer repeatCount = triggerParameters.getInt(TriggerParameters.repeatCount);
            Boolean repeatForever = triggerParameters.getBoolean(TriggerParameters.repeatForever);
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            if (intervalInMilliseconds != null) {
                builder.withIntervalInMilliseconds(intervalInMilliseconds.longValue());
            }
            if (intervalInMinutes != null) {
                builder.withIntervalInMinutes(intervalInMinutes.intValue());
            }
            if (intervalInSeconds != null) {
                builder.withIntervalInSeconds(intervalInSeconds.intValue());
            }
            if (intervalInHours != null) {
                builder.withIntervalInHours(intervalInHours.intValue());
            }
            if (repeatCount != null) {
                builder.withRepeatCount(repeatCount.intValue());
            }
            if (Boolean.TRUE.equals(repeatForever)) {
                builder.repeatForever();
            }
            return TriggerBuilder.newTrigger().withIdentity(name, group).startAt(firstFireTime).withSchedule((ScheduleBuilder)builder).build();
        }
        String expression = triggerParameters.getString(TriggerParameters.expression);
        CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)expression);
        return TriggerBuilder.newTrigger().withIdentity(name, group).startAt(firstFireTime).withSchedule((ScheduleBuilder)cronSchedule).build();
    }
}

