/*
 * Copyright (c) 2008-2021 The Aspectran Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aspectran.core.util.apon;

public class AponFormat {

    protected static final char CURLY_BRACKET_OPEN = '{';

    protected static final char CURLY_BRACKET_CLOSE = '}';

    protected static final char SQUARE_BRACKET_OPEN = '[';

    protected static final char SQUARE_BRACKET_CLOSE = ']';

    protected static final char ROUND_BRACKET_OPEN = '(';

    protected static final char ROUND_BRACKET_CLOSE = ')';

    public static final char TEXT_LINE_START = '|';

    protected static final char NAME_VALUE_SEPARATOR = ':';

    protected static final char COMMENT_LINE_START = '#';

    protected static final char NO_CONTROL_CHAR = 0;

    protected static final char DOUBLE_QUOTE_CHAR = '"';

    protected static final char SINGLE_QUOTE_CHAR = '\'';

    protected static final char ESCAPE_CHAR = '\\';

    public static final char NEW_LINE_CHAR = '\n';

    public static final String NEW_LINE = "\n";

    public static final String SYSTEM_NEW_LINE = System.lineSeparator();

    protected static final String DEFAULT_INDENT_STRING = "  ";

    protected static final String SPACE = " ";

    protected static final char SPACE_CHAR = ' ';

    protected static final String NULL = "null";

    protected static final String TRUE = "true";

    protected static final String FALSE = "false";

}
