/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.AbstractActivity;
import com.aspectran.core.activity.aspect.AdviceConstraintViolationException;
import com.aspectran.core.activity.aspect.AspectAdviceException;
import com.aspectran.core.activity.aspect.AspectAdviceResult;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.component.aspect.AspectAdviceRulePostRegister;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.TokenEvaluator;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AdviceActivity
extends AbstractActivity {
    private static final Logger logger = LoggerFactory.getLogger(AdviceActivity.class);
    private Map<String, Object> settings;
    private AspectAdviceRuleRegistry aspectAdviceRuleRegistry;
    private Set<AspectRule> relevantAspectRules;
    private Set<AspectAdviceRule> executedAspectAdviceRules;
    private AspectAdviceType currentAspectAdviceType;
    private AspectAdviceRule currentAspectAdviceRule;
    private AspectAdviceResult aspectAdviceResult;

    public AdviceActivity(ActivityContext context) {
        super(context);
    }

    protected void prepareAspectAdviceRule(TransletRule transletRule, String requestName) {
        AspectAdviceRuleRegistry aarr;
        if (transletRule.hasPathVariables()) {
            AspectAdviceRulePostRegister postRegister = new AspectAdviceRulePostRegister();
            for (AspectRule aspectRule : this.getActivityContext().getAspectRuleRegistry().getAspectRules()) {
                Pointcut pointcut;
                if (aspectRule.isBeanRelevant() || (pointcut = aspectRule.getPointcut()) != null && !pointcut.matches(requestName)) continue;
                postRegister.register(aspectRule);
            }
            aarr = postRegister.getAspectAdviceRuleRegistry();
        } else {
            aarr = transletRule.replicateAspectAdviceRuleRegistry();
        }
        if (aarr != null) {
            if (this.aspectAdviceRuleRegistry != null) {
                this.aspectAdviceRuleRegistry.merge(aarr);
            } else {
                this.aspectAdviceRuleRegistry = aarr;
            }
        }
    }

    @Override
    public void registerSettingsAdviceRule(SettingsAdviceRule settingsAdviceRule) {
        if (this.relevantAspectRules != null && this.relevantAspectRules.contains(settingsAdviceRule.getAspectRule())) {
            return;
        }
        this.touchRelevantAspectRules().add(settingsAdviceRule.getAspectRule());
        this.touchAspectAdviceRuleRegistry().addAspectAdviceRule(settingsAdviceRule);
    }

    @Override
    public void registerAspectAdviceRule(AspectRule aspectRule) throws AdviceConstraintViolationException, AspectAdviceException {
        block13: {
            if (this.currentAspectAdviceType == null) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at an UNKNOWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                logger.error(msg);
                throw ex;
            }
            if (this.currentAspectAdviceType == AspectAdviceType.THROWN) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at the THROWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                logger.error(msg);
                throw ex;
            }
            if (this.relevantAspectRules != null && this.relevantAspectRules.contains(aspectRule)) {
                return;
            }
            this.touchRelevantAspectRules().add(aspectRule);
            this.touchAspectAdviceRuleRegistry().register(aspectRule);
            List<AspectAdviceRule> aspectAdviceRuleList = aspectRule.getAspectAdviceRuleList();
            if (aspectAdviceRuleList == null) break block13;
            if (this.currentAspectAdviceType == AspectAdviceType.FINALLY) {
                AdviceConstraintViolationException ex = null;
                for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                    AspectAdviceType aspectAdviceType = aspectAdviceRule.getAspectAdviceType();
                    if (aspectAdviceType != AspectAdviceType.BEFORE && aspectAdviceType != AspectAdviceType.AFTER) continue;
                    if (ex == null) {
                        ex = new AdviceConstraintViolationException();
                    }
                    String msg = "BEFORE or AFTER advice should never be registered after the FINALLY activity phase";
                    if ((msg = ex.addViolation(aspectRule, msg)) == null) continue;
                    logger.error(msg);
                }
                if (ex != null) {
                    throw ex;
                }
            }
            if (this.currentAspectAdviceRule != null) {
                AspectAdviceRule adviceRule1 = this.currentAspectAdviceRule;
                AspectAdviceType adviceType1 = adviceRule1.getAspectAdviceType();
                for (AspectAdviceRule adviceRule2 : aspectAdviceRuleList) {
                    AspectAdviceType adviceType2 = adviceRule2.getAspectAdviceType();
                    if (adviceType1 == adviceType2) {
                        int order1 = adviceRule1.getAspectRule().getOrder();
                        int order2 = adviceRule2.getAspectRule().getOrder();
                        if (adviceType1 == AspectAdviceType.BEFORE) {
                            if (order2 >= order1) continue;
                            this.executeAdvice(adviceRule2, true);
                            continue;
                        }
                        if (order2 <= order1) continue;
                        this.executeAdvice(adviceRule2, true);
                        continue;
                    }
                    if (adviceType2 != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(adviceRule2, true);
                }
            } else {
                for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                    if (aspectAdviceRule.getAspectAdviceType() != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(aspectAdviceRule, true);
                }
            }
        }
    }

    protected void setCurrentAspectAdviceType(AspectAdviceType aspectAdviceType) {
        this.currentAspectAdviceType = aspectAdviceType;
    }

    @Override
    public void executeAdvice(List<AspectAdviceRule> aspectAdviceRuleList, boolean throwable) throws AspectAdviceException {
        if (aspectAdviceRuleList != null && !aspectAdviceRuleList.isEmpty()) {
            while (true) {
                AspectAdviceRule target = null;
                if (this.executedAspectAdviceRules == null) {
                    target = aspectAdviceRuleList.get(0);
                } else {
                    for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                        if (this.executedAspectAdviceRules.contains(aspectAdviceRule)) continue;
                        target = aspectAdviceRule;
                        break;
                    }
                }
                if (target == null) break;
                this.executeAdvice(target, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAdvice(AspectAdviceRule aspectAdviceRule, boolean throwable) throws AspectAdviceException {
        if (aspectAdviceRule.getAspectRule().isDisabled() || !this.isAcceptable(aspectAdviceRule.getAspectRule())) {
            this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
            return;
        }
        if (this.isExceptionRaised() && aspectAdviceRule.getExceptionRule() != null) {
            try {
                this.handleException(aspectAdviceRule.getExceptionRule());
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    logger.error("Failed to execute isolated advice action " + aspectAdviceRule, e);
                }
                if (throwable) {
                    throw new AspectAdviceException("Failed to execute advice action " + aspectAdviceRule, aspectAdviceRule, e);
                }
                logger.error("Failed to execute advice action " + aspectAdviceRule, e);
            }
        }
        this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
        Executable action = aspectAdviceRule.getExecutableAction();
        if (action != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Advice " + action);
            }
            AspectAdviceRule oldAspectAdviceRule = this.currentAspectAdviceRule;
            this.currentAspectAdviceRule = aspectAdviceRule;
            try {
                Object adviceBean;
                if (action.getActionType() == ActionType.ACTION) {
                    if (aspectAdviceRule.getAdviceBeanId() != null && (adviceBean = this.getAspectAdviceBean(aspectAdviceRule.getAspectId())) == null) {
                        adviceBean = aspectAdviceRule.getAdviceBeanClass() != null ? this.getBean(aspectAdviceRule.getAdviceBeanClass()) : this.getBean(aspectAdviceRule.getAdviceBeanId());
                        this.putAspectAdviceBean(aspectAdviceRule.getAspectId(), adviceBean);
                    }
                } else if (action.getActionType() == ActionType.ACTION_ANNOTATED && (adviceBean = this.getAspectAdviceBean(aspectAdviceRule.getAspectId())) == null) {
                    adviceBean = this.getBean(aspectAdviceRule.getAdviceBeanClass());
                    this.putAspectAdviceBean(aspectAdviceRule.getAspectId(), adviceBean);
                }
                Object resultValue = action.execute(this);
                if (!action.isHidden() && resultValue != null && resultValue != ActionResult.NO_RESULT) {
                    this.putAdviceResult(aspectAdviceRule, resultValue);
                    if (action.getActionType() == ActionType.ECHO) {
                        if (action.getActionId() != null) {
                            this.getRequestAdapter().setAttribute(action.getActionId(), resultValue);
                        } else {
                            Map echos = (Map)resultValue;
                            for (Map.Entry item : echos.entrySet()) {
                                this.getRequestAdapter().setAttribute((String)item.getKey(), item.getValue());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    logger.error("Failed to execute an isolated advice action " + aspectAdviceRule, e);
                } else {
                    this.setRaisedException(e);
                    if (throwable) {
                        throw new AspectAdviceException("Failed to execute an advice action " + aspectAdviceRule, aspectAdviceRule, e);
                    }
                    logger.error("Failed to execute an advice action " + aspectAdviceRule, e);
                }
            }
            finally {
                this.currentAspectAdviceRule = oldAspectAdviceRule;
            }
        }
    }

    private boolean isAcceptable(AspectRule aspectRule) {
        if (aspectRule.getMethods() != null) {
            if (this.getTranslet() == null) {
                return false;
            }
            MethodType requestMethod = this.getTranslet().getRequestMethod();
            if (requestMethod == null || !requestMethod.containsTo(aspectRule.getMethods())) {
                return false;
            }
        }
        if (aspectRule.getHeaders() != null) {
            for (String header : aspectRule.getHeaders()) {
                if (!this.getRequestAdapter().containsHeader(header)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void handleException(List<ExceptionRule> exceptionRuleList) throws ActionExecutionException {
        if (exceptionRuleList != null) {
            for (ExceptionRule exceptionRule : exceptionRuleList) {
                this.handleException(exceptionRule);
            }
        }
    }

    protected ExceptionThrownRule handleException(ExceptionRule exceptionRule) throws ActionExecutionException {
        ExceptionThrownRule exceptionThrownRule;
        if (exceptionRule != null && (exceptionThrownRule = exceptionRule.getExceptionThrownRule(this.getRaisedException())) != null) {
            Executable action = exceptionThrownRule.getAction();
            if (action != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Advice " + action);
                }
                try {
                    Object resultValue = action.execute(this);
                    if (this.getTranslet() != null && !action.isHidden() && resultValue != ActionResult.NO_RESULT) {
                        if (resultValue instanceof ProcessResult) {
                            this.getTranslet().setProcessResult((ProcessResult)resultValue);
                        } else {
                            ContentResult contentResult;
                            ProcessResult processResult = this.getTranslet().getProcessResult();
                            if (processResult == null) {
                                processResult = new ProcessResult(1);
                                contentResult = new ContentResult(processResult, 1);
                                this.getTranslet().setProcessResult(processResult);
                            } else {
                                contentResult = processResult.lastContentResult();
                                if (contentResult == null) {
                                    contentResult = new ContentResult(processResult, 1);
                                }
                            }
                            contentResult.addActionResult(action, resultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.setRaisedException(e);
                    throw new ActionExecutionException("Failed to execute advice action " + action + " for exception handling", (Throwable)e);
                }
            }
            return exceptionThrownRule;
        }
        return null;
    }

    protected List<AspectAdviceRule> getBeforeAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getBeforeAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getAfterAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getAfterAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getFinallyAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getFinallyAdviceRuleList();
        }
        return null;
    }

    protected List<ExceptionRule> getExceptionRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getExceptionRuleList();
        }
        return null;
    }

    @Override
    public <V> V getSetting(String name) {
        Object value;
        if (this.settings != null && (value = this.settings.get(name)) != null) {
            return (V)value;
        }
        if (this.aspectAdviceRuleRegistry != null && this.aspectAdviceRuleRegistry.getSettingsAdviceRuleList() != null) {
            for (SettingsAdviceRule settingsAdviceRule : this.aspectAdviceRuleRegistry.getSettingsAdviceRuleList()) {
                Object value2 = settingsAdviceRule.getSetting(name);
                if (value2 == null || !this.isAcceptable(settingsAdviceRule.getAspectRule())) continue;
                if (value2 instanceof String) {
                    return (V)TokenEvaluator.evaluate((String)value2, this);
                }
                return (V)value2;
            }
        }
        return null;
    }

    @Override
    public void putSetting(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Setting name must not be null or empty");
        }
        if (this.settings == null) {
            this.settings = new LinkedHashMap<String, Object>();
        }
        this.settings.put(name, value);
    }

    @Override
    public <V> V getAspectAdviceBean(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAspectAdviceBean(aspectId) : null);
    }

    protected void putAspectAdviceBean(String aspectId, Object adviceBean) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAspectAdviceBean(aspectId, adviceBean);
    }

    public <V> V getBeforeAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getBeforeAdviceResult(aspectId) : null);
    }

    public <V> V getAfterAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAfterAdviceResult(aspectId) : null);
    }

    public <V> V getAroundAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAroundAdviceResult(aspectId) : null);
    }

    public <V> V getFinallyAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getFinallyAdviceResult(aspectId) : null);
    }

    protected void putAdviceResult(AspectAdviceRule aspectAdviceRule, Object adviceActionResult) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAdviceResult(aspectAdviceRule, adviceActionResult);
    }

    private AspectAdviceRuleRegistry touchAspectAdviceRuleRegistry() {
        if (this.aspectAdviceRuleRegistry == null) {
            this.aspectAdviceRuleRegistry = new AspectAdviceRuleRegistry();
        }
        return this.aspectAdviceRuleRegistry;
    }

    private Set<AspectRule> touchRelevantAspectRules() {
        if (this.relevantAspectRules == null) {
            this.relevantAspectRules = new HashSet<AspectRule>();
        }
        return this.relevantAspectRules;
    }

    private Set<AspectAdviceRule> touchExecutedAspectAdviceRules() {
        if (this.executedAspectAdviceRules == null) {
            this.executedAspectAdviceRules = new HashSet<AspectAdviceRule>();
        }
        return this.executedAspectAdviceRules;
    }
}

