/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.ActivityPerformException;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.AdviceActivity;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.InstantAction;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.request.MissingMandatoryAttributesException;
import com.aspectran.core.activity.request.MissingMandatoryParametersException;
import com.aspectran.core.activity.request.PathVariableMap;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.component.bean.scope.RequestScope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.ItemEvaluation;
import com.aspectran.core.context.expr.ItemEvaluator;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.ArrayList;

public class CoreActivity
extends AdviceActivity {
    private static final Logger logger = LoggerFactory.getLogger(CoreActivity.class);
    private CoreTranslet translet;
    private Response reservedResponse;
    private Response desiredResponse;
    private boolean committed;

    protected CoreActivity(ActivityContext context) {
        super(context);
    }

    public void prepare(String requestName) throws TransletNotFoundException, ActivityPrepareException {
        TransletRule transletRule = this.getTransletRule(requestName, MethodType.GET);
        if (transletRule == null) {
            throw new TransletNotFoundException(requestName, MethodType.GET);
        }
        this.prepare(requestName, MethodType.GET, transletRule);
    }

    public void prepare(TransletRule transletRule) throws ActivityPrepareException {
        this.prepare(transletRule.getName(), transletRule);
    }

    public void prepare(String requestName, TransletRule transletRule) throws ActivityPrepareException {
        this.prepare(requestName, MethodType.GET, transletRule);
    }

    public void prepare(String requestName, String requestMethod) throws TransletNotFoundException, ActivityPrepareException {
        this.prepare(requestName, MethodType.resolve(requestMethod));
    }

    public void prepare(String requestName, MethodType requestMethod) throws TransletNotFoundException, ActivityPrepareException {
        TransletRule transletRule;
        if (requestMethod == null) {
            requestMethod = MethodType.GET;
        }
        if ((transletRule = this.getTransletRule(requestName, requestMethod)) == null) {
            throw new TransletNotFoundException(requestName, requestMethod);
        }
        this.prepare(requestName, requestMethod, transletRule);
    }

    private void prepare(String requestName, MethodType requestMethod, TransletRule transletRule) throws ActivityPrepareException {
        CoreTranslet parentTranslet = this.translet;
        try {
            MethodType allowedMethod;
            if (logger.isDebugEnabled()) {
                logger.debug("Translet " + transletRule);
            }
            this.translet = new CoreTranslet(transletRule, this);
            this.translet.setRequestName(requestName);
            this.translet.setRequestMethod(requestMethod);
            if (parentTranslet != null) {
                this.translet.setParentTranslet(parentTranslet);
            }
            if ((allowedMethod = this.getRequestRule().getAllowedMethod()) != null && !allowedMethod.equals((Object)requestMethod)) {
                throw new RequestMethodNotAllowedException(allowedMethod);
            }
            this.prepareAspectAdviceRule(transletRule, requestName);
        }
        catch (Exception e) {
            throw new ActivityPrepareException("Failed to prepare activity for translet " + transletRule, e);
        }
    }

    protected void adapt() throws AdapterException {
    }

    protected void parseRequest() throws ActivityTerminatedException, RequestParseException {
    }

    protected LocaleResolver resolveLocale() {
        LocaleResolver localeResolver = null;
        String localeResolverBeanId = (String)this.getSetting("localeResolver");
        if (localeResolverBeanId != null) {
            localeResolver = this.getBean(LocaleResolver.class, localeResolverBeanId);
            localeResolver.resolveLocale(this.getTranslet());
            localeResolver.resolveTimeZone(this.getTranslet());
        }
        return localeResolver;
    }

    @Override
    public void perform() throws ActivityPerformException {
        this.perform(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V perform(InstantAction<V> instantAction) throws ActivityPerformException {
        V result = null;
        ForwardRule forwardRule = null;
        try {
            if (this.translet == null || !this.translet.hasParentTranslet()) {
                this.saveCurrentActivity();
                this.adapt();
                this.parseRequest();
            }
            if (this.translet != null) {
                this.parseDeclaredParameters();
                this.parseDeclaredAttributes();
                this.parsePathVariables();
                if (!this.translet.hasParentTranslet()) {
                    this.resolveLocale();
                }
            }
            try {
                this.setCurrentAspectAdviceType(AspectAdviceType.BEFORE);
                this.executeAdvice(this.getBeforeAdviceRuleList(), true);
                if (this.translet != null) {
                    if (!this.isResponseReserved()) {
                        this.produce();
                    }
                    if ((forwardRule = this.response()) != null) {
                        V v = this.forward(forwardRule, instantAction);
                        return v;
                    }
                }
                if (instantAction != null) {
                    result = instantAction.execute();
                }
                this.setCurrentAspectAdviceType(AspectAdviceType.AFTER);
                this.executeAdvice(this.getAfterAdviceRuleList(), true);
            }
            catch (Exception e) {
                this.setRaisedException(e);
            }
            finally {
                if (forwardRule == null) {
                    this.setCurrentAspectAdviceType(AspectAdviceType.FINALLY);
                    this.executeAdvice(this.getFinallyAdviceRuleList(), false);
                }
            }
            if (this.isExceptionRaised()) {
                this.setCurrentAspectAdviceType(AspectAdviceType.THROWN);
                this.exception();
                if (this.translet != null) {
                    this.response();
                }
                if (this.isExceptionRaised()) {
                    throw this.getRaisedException();
                }
            }
            this.setCurrentAspectAdviceType(null);
            return result;
        }
        catch (ActivityTerminatedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ActivityPerformException("Failed to perform the activity", e);
        }
        finally {
            if (forwardRule == null) {
                this.finish();
            }
        }
    }

    private void produce() throws ActionExecutionException {
        ActionList actionList;
        ContentList contentList = this.getTransletRule().getContentList();
        if (contentList != null) {
            ProcessResult processResult = this.translet.getProcessResult();
            if (processResult == null) {
                processResult = new ProcessResult(contentList.size());
                processResult.setName(contentList.getName());
                processResult.setExplicit(contentList.isExplicit());
                this.translet.setProcessResult(processResult);
            }
            for (ActionList actionList2 : contentList) {
                this.execute(actionList2);
                if (!this.isResponseReserved()) continue;
                break;
            }
        }
        if ((actionList = this.getResponseRule().getActionList()) != null) {
            this.execute(actionList);
        }
    }

    private ForwardRule response() throws ResponseException {
        if (this.committed) {
            return null;
        }
        this.committed = true;
        Response res = this.getResponse();
        if (res != null) {
            res.commit(this);
            if (this.isExceptionRaised()) {
                this.clearRaisedException();
            }
            if (res.getResponseType() == ResponseType.FORWARD) {
                ForwardResponse forwardResponse = (ForwardResponse)res;
                return forwardResponse.getForwardRule();
            }
        }
        return null;
    }

    private <V> V forward(ForwardRule forwardRule, InstantAction<V> instantAction) throws TransletNotFoundException, ActivityPrepareException, ActivityPerformException {
        if (logger.isDebugEnabled()) {
            logger.debug("Forwarding from " + this.translet.getRequestName() + " to " + forwardRule.getTransletName());
        }
        this.reserveResponse(null);
        this.committed = false;
        this.prepare(forwardRule.getTransletName(), forwardRule.getRequestMethod());
        return this.perform(instantAction);
    }

    private void exception() throws ActionExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Exception handling for " + this.getRaisedException(), this.getRaisedException());
        }
        this.reserveResponse(null);
        this.committed = false;
        if (this.translet != null && this.getTransletRule().getExceptionRule() != null) {
            this.handleException(this.getTransletRule().getExceptionRule());
        }
        if (this.getExceptionRuleList() != null) {
            this.handleException(this.getExceptionRuleList());
        }
    }

    protected void release() {
    }

    private void finish() {
        try {
            RequestScope requestScope = this.getRequestAdapter().getRequestScope(false);
            if (requestScope != null) {
                requestScope.destroy();
            }
            this.release();
            if (this.getResponseAdapter() != null) {
                this.getResponseAdapter().flush();
            }
        }
        catch (Exception e) {
            logger.error("An error was detected while finishing an activity", e);
        }
        finally {
            this.removeCurrentActivity();
        }
    }

    protected void execute(ActionList actionList) throws ActionExecutionException {
        this.execute(actionList, null);
    }

    protected void execute(ActionList actionList, ContentResult contentResult) throws ActionExecutionException {
        if (contentResult == null) {
            ProcessResult processResult = this.translet.getProcessResult();
            if (processResult == null) {
                processResult = new ProcessResult(2);
                this.translet.setProcessResult(processResult);
            }
            if ((contentResult = processResult.getContentResult(actionList.getName(), actionList.isExplicit())) == null) {
                contentResult = new ContentResult(processResult, actionList.size());
                contentResult.setName(actionList.getName());
                if (!processResult.isExplicit()) {
                    contentResult.setExplicit(actionList.isExplicit());
                }
            }
        }
        for (Executable action : actionList) {
            this.execute(action, contentResult);
            if (!this.isResponseReserved()) continue;
            break;
        }
    }

    private void execute(Executable action, ContentResult contentResult) throws ActionExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Action " + action);
            }
            if (action.getActionType() == ActionType.CHOOSE) {
                Object resultValue = action.execute(this);
                if (resultValue != ActionResult.NO_RESULT) {
                    ChooseWhenRule chooseWhenRule = (ChooseWhenRule)resultValue;
                    ActionList actionList = chooseWhenRule.getActionList();
                    this.execute(actionList, contentResult);
                    if (chooseWhenRule.getResponse() != null) {
                        this.reserveResponse(chooseWhenRule.getResponse());
                    }
                }
            } else {
                Object resultValue = action.execute(this);
                if (!action.isHidden() && contentResult != null && resultValue != ActionResult.NO_RESULT) {
                    if (resultValue instanceof ProcessResult) {
                        contentResult.addActionResult(action, (ProcessResult)resultValue);
                    } else {
                        contentResult.addActionResult(action, resultValue);
                    }
                }
            }
        }
        catch (ActionExecutionException e) {
            logger.error("Failed to execute action " + action, e);
            throw e;
        }
        catch (Exception e) {
            this.setRaisedException(e);
            throw new ActionExecutionException("Failed to execute action " + action, (Throwable)e);
        }
    }

    @Override
    public ExceptionThrownRule handleException(ExceptionRule exceptionRule) throws ActionExecutionException {
        Response response;
        String contentType;
        Response targetResponse;
        ExceptionThrownRule exceptionThrownRule = super.handleException(exceptionRule);
        if (this.translet != null && exceptionThrownRule != null && !this.isResponseReserved() && (targetResponse = exceptionThrownRule.getResponse(contentType = (response = this.getDesiredResponse()) != null ? response.getContentType() : null)) != null) {
            this.reserveResponse(targetResponse);
        }
        return exceptionThrownRule;
    }

    private Response getResponse() {
        Response res = this.reservedResponse;
        if (res == null && !this.isExceptionRaised()) {
            res = this.getDeclaredResponse();
        }
        return res;
    }

    protected void reserveResponse(@Nullable Response response) {
        this.reservedResponse = response;
        if (response != null && !this.isExceptionRaised()) {
            this.desiredResponse = response;
        }
    }

    protected void reserveResponse() {
        if (this.reservedResponse == null) {
            this.reservedResponse = this.getDeclaredResponse();
        }
    }

    @Override
    public boolean isResponseReserved() {
        return this.reservedResponse != null;
    }

    protected Response getDesiredResponse() {
        return this.desiredResponse != null ? this.desiredResponse : this.getDeclaredResponse();
    }

    @Override
    public Translet getTranslet() {
        return this.translet;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.translet != null ? this.translet.getProcessResult() : null;
    }

    @Override
    public Object getProcessResult(String actionId) {
        if (this.translet != null) {
            return this.translet.getProcessResult().getResultValue(actionId);
        }
        return null;
    }

    private TransletRule getTransletRule(String transletName, MethodType requestMethod) {
        return this.getActivityContext().getTransletRuleRegistry().getTransletRule(transletName, requestMethod);
    }

    protected TransletRule getTransletRule() {
        return this.translet.getTransletRule();
    }

    protected RequestRule getRequestRule() {
        return this.translet.getRequestRule();
    }

    protected ResponseRule getResponseRule() {
        return this.translet.getResponseRule();
    }

    @Override
    public Response getDeclaredResponse() {
        return this.getResponseRule() != null ? this.getResponseRule().getResponse() : null;
    }

    protected String getIntendedRequestEncoding() {
        String encoding = this.getRequestRule().getEncoding();
        if (encoding == null) {
            encoding = (String)this.getSetting("characterEncoding");
        }
        return encoding;
    }

    protected String getIntendedResponseEncoding() {
        String encoding = this.getResponseRule().getEncoding();
        if (encoding == null) {
            encoding = this.getIntendedRequestEncoding();
        }
        return encoding;
    }

    protected void parseDeclaredParameters() throws MissingMandatoryParametersException {
        ItemRuleMap itemRuleMap = this.getRequestRule().getParameterItemRuleMap();
        if (itemRuleMap != null && !itemRuleMap.isEmpty()) {
            ItemEvaluator evaluator = null;
            ArrayList missingItemRules = null;
            for (ItemRule itemRule : itemRuleMap.values()) {
                String[] values;
                if (itemRule.isEvaluable()) {
                    String[] oldValues;
                    if (evaluator == null) {
                        evaluator = new ItemEvaluation(this);
                    }
                    if ((values = evaluator.evaluateAsStringArray(itemRule)) != (oldValues = this.getRequestAdapter().getParameterValues(itemRule.getName()))) {
                        this.getRequestAdapter().setParameter(itemRule.getName(), values);
                    }
                }
                if (!itemRule.isMandatory() || (values = this.getRequestAdapter().getParameterValues(itemRule.getName())) != null) continue;
                if (missingItemRules == null) {
                    missingItemRules = new ItemRuleList();
                }
                missingItemRules.add(itemRule);
            }
            if (missingItemRules != null) {
                throw new MissingMandatoryParametersException(missingItemRules);
            }
        }
    }

    protected void parseDeclaredAttributes() throws MissingMandatoryAttributesException {
        ItemRuleMap itemRuleMap = this.getRequestRule().getAttributeItemRuleMap();
        if (itemRuleMap != null && !itemRuleMap.isEmpty()) {
            ItemEvaluator evaluator = null;
            ArrayList missingItemRules = null;
            for (ItemRule itemRule : itemRuleMap.values()) {
                Object value;
                if (itemRule.isEvaluable()) {
                    Object oldValue;
                    if (evaluator == null) {
                        evaluator = new ItemEvaluation(this);
                    }
                    if ((value = evaluator.evaluate(itemRule)) != (oldValue = this.getRequestAdapter().getAttribute(itemRule.getName()))) {
                        this.getRequestAdapter().setAttribute(itemRule.getName(), value);
                    }
                }
                if (!itemRule.isMandatory() || (value = this.getRequestAdapter().getAttribute(itemRule.getName())) != null) continue;
                if (missingItemRules == null) {
                    missingItemRules = new ItemRuleList();
                }
                missingItemRules.add(itemRule);
            }
            if (missingItemRules != null) {
                throw new MissingMandatoryAttributesException(missingItemRules);
            }
        }
    }

    private void parsePathVariables() {
        PathVariableMap pathVariables;
        Token[] nameTokens = this.getTransletRule().getNameTokens();
        if (nameTokens != null && (nameTokens.length != 1 || nameTokens[0].getType() != TokenType.TEXT) && (pathVariables = PathVariableMap.parse(nameTokens, this.translet.getRequestName())) != null) {
            pathVariables.applyTo(this.translet);
        }
    }
}

