/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.InvokeAction;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.util.ToStringBuilder;

public class AdviceAction
extends InvokeAction {
    private final AspectAdviceRule aspectAdviceRule;

    public AdviceAction(InvokeActionRule invokeActionRule, AspectAdviceRule aspectAdviceRule) {
        super(invokeActionRule);
        this.aspectAdviceRule = aspectAdviceRule;
    }

    public AspectAdviceRule getAspectAdviceRule() {
        return this.aspectAdviceRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        if (this.getInvokeActionRule().getBeanId() != null) {
            return super.execute(activity);
        }
        Object bean = activity.getAspectAdviceBean(this.aspectAdviceRule.getAspectId());
        if (bean == null) {
            throw new ActionExecutionException("No advice bean found for " + this.aspectAdviceRule);
        }
        return this.execute(activity, bean);
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.aspectAdviceRule.getAspectAdviceType());
        tsb.append("bean", this.aspectAdviceRule.getAdviceBeanId());
        tsb.append("bean", this.aspectAdviceRule.getAdviceBeanClass());
        if (this.getInvokeActionRule().getMethod() != null) {
            tsb.append("method", this.getInvokeActionRule().getMethod());
        } else {
            tsb.append("method", this.getInvokeActionRule().getMethodName());
        }
        tsb.append("order", this.aspectAdviceRule.getAspectRule().getOrder());
        return tsb.toString();
    }
}

