/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.expr.ItemEvaluation;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.Map;

public class IncludeAction
implements Executable {
    private final IncludeActionRule includeActionRule;

    public IncludeAction(IncludeActionRule includeActionRule) {
        this.includeActionRule = includeActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        try {
            InstantActivity instantActivity = new InstantActivity(activity.getActivityContext());
            ItemRuleMap parameterItemRuleMap = this.includeActionRule.getParameterItemRuleMap();
            ItemRuleMap attributeItemRuleMap = this.includeActionRule.getAttributeItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty() || attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                ItemEvaluation evaluator = new ItemEvaluation(activity);
                if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
                    ParameterMap parameterMap = evaluator.evaluateAsParameterMap(parameterItemRuleMap);
                    instantActivity.setParameterMap(parameterMap);
                }
                if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                    Map<String, Object> attributeMap = evaluator.evaluate(attributeItemRuleMap);
                    instantActivity.setAttributeMap(attributeMap);
                }
            }
            instantActivity.prepare(this.includeActionRule.getTransletName(), this.includeActionRule.getMethodType());
            instantActivity.perform();
            return instantActivity.getProcessResult();
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute action " + this, (Throwable)e);
        }
    }

    public IncludeActionRule getIncludeActionRule() {
        return this.includeActionRule;
    }

    @Override
    public String getActionId() {
        return this.includeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.includeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INCLUDE;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.getIncludeActionRule();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("include", this.includeActionRule);
        return tsb.toString();
    }
}

