/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.expr.ItemEvaluation;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.Map;

public class ForwardResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(ForwardResponse.class);
    private final ForwardRule forwardRule;

    public ForwardResponse(ForwardRule forwardRule) {
        this.forwardRule = forwardRule;
    }

    @Override
    public void commit(Activity activity) {
        ItemRuleMap itemRuleMap;
        RequestAdapter requestAdapter = activity.getRequestAdapter();
        if (requestAdapter == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response " + this.forwardRule);
        }
        if ((itemRuleMap = this.forwardRule.getAttributeItemRuleMap()) != null && !itemRuleMap.isEmpty()) {
            ItemEvaluation evaluator = new ItemEvaluation(activity);
            Map<String, Object> valueMap = evaluator.evaluate(itemRuleMap);
            requestAdapter.putAllAttributes(valueMap);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return ForwardRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        if (this.forwardRule != null) {
            return this.forwardRule.getContentType();
        }
        return null;
    }

    @Override
    public Response replicate() {
        return new ForwardResponse(this.forwardRule.replicate());
    }

    public ForwardRule getForwardRule() {
        return this.forwardRule;
    }

    public String toString() {
        return this.forwardRule.toString();
    }
}

