/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.lang.NonNull;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;

public class ResponseTemplate
implements Response,
ResponseAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseTemplate.class);
    private final ResponseAdapter responseAdapter;

    public ResponseTemplate(@NonNull ResponseAdapter responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        if (logger.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder();
            tsb.appendForce("type", (Object)this.getResponseType());
            logger.debug("Response " + tsb);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.TEMPLATE;
    }

    @Override
    public <T> T getAdaptee() {
        return this.responseAdapter.getAdaptee();
    }

    @Override
    public String getHeader(String name) {
        return this.responseAdapter.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.responseAdapter.getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.responseAdapter.getHeaderNames();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.responseAdapter.containsHeader(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.responseAdapter.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.responseAdapter.addHeader(name, value);
    }

    @Override
    public String getEncoding() {
        return this.responseAdapter.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.responseAdapter.setEncoding(encoding);
    }

    @Override
    public String getContentType() {
        return this.responseAdapter.getContentType();
    }

    @Override
    public void setContentType(String contentType) {
        this.responseAdapter.setContentType(contentType);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.responseAdapter.getOutputStream();
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.responseAdapter.getWriter();
    }

    @Override
    public void flush() throws IOException {
        this.responseAdapter.flush();
    }

    @Override
    public void redirect(String location) throws IOException {
        this.responseAdapter.redirect(location);
    }

    @Override
    public String redirect(RedirectRule redirectRule) throws IOException {
        return this.responseAdapter.redirect(redirectRule);
    }

    @Override
    public int getStatus() {
        return this.responseAdapter.getStatus();
    }

    @Override
    public void setStatus(int status) {
        this.responseAdapter.setStatus(status);
    }

    @Override
    public Response replicate() {
        throw new UnsupportedOperationException();
    }
}

