/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.FormattingContext;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.apon.ContentsToAponConverter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameters;
import java.io.IOException;
import java.io.Writer;

public class AponTransformResponse
extends TransformResponse {
    private final String contentType;
    private final String encoding;
    private final Boolean pretty;

    public AponTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.pretty = transformRule.getPretty();
    }

    @Override
    public void transform(Activity activity) throws Exception {
        ProcessResult processResult;
        String encoding;
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (this.encoding != null) {
            responseAdapter.setEncoding(this.encoding);
        } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getIntendedResponseEncoding()) != null) {
            responseAdapter.setEncoding(encoding);
        }
        if (this.contentType != null) {
            responseAdapter.setContentType(this.contentType);
        }
        if ((processResult = activity.getProcessResult()) != null && !processResult.isEmpty()) {
            FormattingContext formattingContext = FormattingContext.parse(activity);
            if (this.pretty != null) {
                formattingContext.setPretty(this.pretty);
            }
            Writer writer = responseAdapter.getWriter();
            AponTransformResponse.transform(processResult, writer, formattingContext);
        }
    }

    @Override
    public Response replicate() {
        TransformRule transformRule = this.getTransformRule().replicate();
        return new AponTransformResponse(transformRule);
    }

    private static void transform(ProcessResult processResult, Writer writer, FormattingContext formattingContext) throws IOException {
        ContentsToAponConverter aponConverter = new ContentsToAponConverter();
        if (formattingContext != null) {
            if (formattingContext.getDateFormat() != null) {
                aponConverter.setDateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                aponConverter.setDateTimeFormat(formattingContext.getDateTimeFormat());
            }
        }
        Parameters parameters = aponConverter.toParameters(processResult);
        AponTransformResponse.transform(parameters, writer, formattingContext);
    }

    public static void transform(Parameters parameters, Writer writer, FormattingContext formattingContext) throws IOException {
        AponWriter aponWriter = new AponWriter(writer);
        if (formattingContext != null) {
            if (formattingContext.getNullWritable() != null) {
                aponWriter.nullWritable(formattingContext.getNullWritable());
            }
            if (formattingContext.isPretty()) {
                String indentString = formattingContext.makeIndentString();
                if (indentString != null) {
                    aponWriter.indentString(indentString);
                } else {
                    aponWriter.prettyPrint(true);
                }
            } else {
                aponWriter.prettyPrint(false);
            }
        }
        aponWriter.write(parameters);
    }
}

