/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.FormattingContext;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.json.ContentsJsonWriter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import java.io.IOException;
import java.io.Writer;

public class JsonTransformResponse
extends TransformResponse {
    public static final String CALLBACK_PARAM_NAME = "callback";
    public static final String ROUND_BRACKET_OPEN = "(";
    public static final String ROUND_BRACKET_CLOSE = ")";
    private final String contentType;
    private final String encoding;
    private final Boolean pretty;

    public JsonTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.pretty = transformRule.getPretty();
    }

    @Override
    protected void transform(Activity activity) throws Exception {
        String encoding;
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (this.encoding != null) {
            responseAdapter.setEncoding(this.encoding);
        } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getIntendedResponseEncoding()) != null) {
            responseAdapter.setEncoding(encoding);
        }
        if (this.contentType != null) {
            responseAdapter.setContentType(this.contentType);
        }
        Writer writer = responseAdapter.getWriter();
        ProcessResult processResult = activity.getProcessResult();
        FormattingContext formattingContext = FormattingContext.parse(activity);
        if (this.pretty != null) {
            formattingContext.setPretty(this.pretty);
        }
        String callback = activity.getTranslet().getParameter(CALLBACK_PARAM_NAME);
        this.transform(processResult, callback, writer, formattingContext);
    }

    @Override
    public Response replicate() {
        return new JsonTransformResponse(this.getTransformRule().replicate());
    }

    private void transform(ProcessResult processResult, String callback, Writer writer, FormattingContext formattingContext) throws IOException {
        if (callback != null) {
            writer.write(callback + ROUND_BRACKET_OPEN);
        }
        ContentsJsonWriter jsonWriter = new ContentsJsonWriter(writer);
        if (formattingContext != null) {
            if (formattingContext.getDateFormat() != null) {
                jsonWriter.dateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                jsonWriter.dateTimeFormat(formattingContext.getDateTimeFormat());
            }
            if (formattingContext.getNullWritable() != null) {
                jsonWriter.nullWritable(formattingContext.getNullWritable());
            }
            if (formattingContext.isPretty()) {
                String indentString = formattingContext.makeIndentString();
                if (indentString != null) {
                    jsonWriter.indentString(indentString);
                } else {
                    jsonWriter.prettyPrint(true);
                }
            } else {
                jsonWriter.prettyPrint(false);
            }
        }
        jsonWriter.write(processResult);
        if (callback != null) {
            writer.write(ROUND_BRACKET_CLOSE);
        }
    }
}

