/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;

public abstract class TransformResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(TransformResponse.class);
    private final TransformRule transformRule;

    public TransformResponse(TransformRule transformRule) {
        this.transformRule = transformRule;
    }

    @Override
    public ResponseType getResponseType() {
        return TransformRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        return this.transformRule.getContentType();
    }

    public FormatType getFormatType() {
        return this.transformRule.getFormatType();
    }

    public TransformRule getTransformRule() {
        return this.transformRule;
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        if (activity.getResponseAdapter() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No response adapter in activity " + activity);
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response " + this.transformRule);
        }
        try {
            this.transform(activity);
        }
        catch (Exception e) {
            throw new TransformResponseException(this.transformRule, (Throwable)e);
        }
    }

    protected abstract void transform(Activity var1) throws Exception;

    public String toString() {
        return this.transformRule.toString();
    }
}

