/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.AponTransformResponse;
import com.aspectran.core.activity.response.transform.JsonTransformResponse;
import com.aspectran.core.activity.response.transform.NoneTransformResponse;
import com.aspectran.core.activity.response.transform.TextTransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.XmlTransformResponse;
import com.aspectran.core.activity.response.transform.XslTransformResponse;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.core.lang.NonNull;

public class TransformResponseFactory {
    public static Response create(@NonNull TransformRule transformRule) {
        TransformResponse res;
        FormatType formatType = transformRule.getFormatType();
        if (formatType == FormatType.APON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.APPLICATION_APON.toString());
            }
            res = new AponTransformResponse(transformRule);
        } else if (formatType == FormatType.JSON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.TEXT_PLAIN.toString());
            }
            res = new JsonTransformResponse(transformRule);
        } else if (formatType == FormatType.TEXT) {
            res = new TextTransformResponse(transformRule);
        } else if (formatType == FormatType.XML) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.APPLICATION_XML.toString());
            }
            res = new XmlTransformResponse(transformRule);
        } else {
            res = formatType == FormatType.XSL ? new XslTransformResponse(transformRule) : new NoneTransformResponse(transformRule);
        }
        return res;
    }
}

