/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.lang.NonNull;
import java.util.Objects;

public class PointcutPattern {
    private static final char POINTCUT_BEAN_NAME_DELIMITER = '@';
    private static final char POINTCUT_METHOD_NAME_DELIMITER = '^';
    private final String transletNamePattern;
    private final String beanIdPattern;
    private final String classNamePattern;
    private final String methodNamePattern;
    private volatile int hashCode;

    public PointcutPattern(String transletNamePattern, String beanIdPattern, String classNamePattern, String methodNamePattern) {
        this.transletNamePattern = transletNamePattern;
        this.beanIdPattern = beanIdPattern;
        this.classNamePattern = classNamePattern;
        this.methodNamePattern = methodNamePattern;
    }

    public String getTransletNamePattern() {
        return this.transletNamePattern;
    }

    public String getBeanIdPattern() {
        return this.beanIdPattern;
    }

    public String getClassNamePattern() {
        return this.classNamePattern;
    }

    public String getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointcutPattern)) {
            return false;
        }
        PointcutPattern pp = (PointcutPattern)o;
        return Objects.equals(this.transletNamePattern, pp.getTransletNamePattern()) && Objects.equals(this.beanIdPattern, pp.getBeanIdPattern()) && Objects.equals(this.classNamePattern, pp.getClassNamePattern()) && Objects.equals(this.methodNamePattern, pp.getMethodNamePattern());
    }

    public int hashCode() {
        int prime = 31;
        int result = this.hashCode;
        if (result == 0) {
            result = 11;
            result = 31 * result + (this.transletNamePattern != null ? this.transletNamePattern.hashCode() : 0);
            result = 31 * result + (this.beanIdPattern != null ? this.beanIdPattern.hashCode() : 0);
            result = 31 * result + (this.classNamePattern != null ? this.classNamePattern.hashCode() : 0);
            this.hashCode = result = 31 * result + (this.methodNamePattern != null ? this.methodNamePattern.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        return PointcutPattern.combinePattern(this);
    }

    public static String combinePattern(@NonNull PointcutPattern pointcutPattern) {
        return PointcutPattern.combinePattern(pointcutPattern.getTransletNamePattern(), pointcutPattern.getBeanIdPattern(), pointcutPattern.getClassNamePattern(), pointcutPattern.getMethodNamePattern());
    }

    public static String combinePattern(String transletName, String beanId, String className, String methodName) {
        int len = 0;
        if (transletName != null && transletName.length() > 0) {
            len += transletName.length();
        }
        if (beanId != null && beanId.length() > 0) {
            len += beanId.length() + 1;
        } else if (className != null && className.length() > 0) {
            len += className.length() + 7;
        }
        if (methodName != null && methodName.length() > 0) {
            len += methodName.length() + 1;
        }
        StringBuilder sb = new StringBuilder(len);
        if (transletName != null && transletName.length() > 0) {
            sb.append(transletName);
        }
        if (beanId != null && beanId.length() > 0) {
            sb.append('@');
            sb.append(beanId);
        } else if (className != null && className.length() > 0) {
            sb.append('@');
            sb.append("class:");
            sb.append(className);
        }
        if (methodName != null && methodName.length() > 0) {
            sb.append('^');
            sb.append(methodName);
        }
        return sb.toString();
    }

    public static PointcutPattern parsePattern(String patternString) {
        String transletNamePattern = null;
        String beanNamePattern = null;
        String methodNamePattern = null;
        int beanNameDelimiterIndex = patternString.indexOf(64);
        if (beanNameDelimiterIndex == -1) {
            transletNamePattern = patternString;
        } else if (beanNameDelimiterIndex == 0) {
            beanNamePattern = patternString.substring(1);
        } else {
            transletNamePattern = patternString.substring(0, beanNameDelimiterIndex);
            beanNamePattern = patternString.substring(beanNameDelimiterIndex + 1);
        }
        if (beanNamePattern != null) {
            int methodNameDelimiterIndex = beanNamePattern.indexOf(94);
            if (methodNameDelimiterIndex == 0) {
                methodNamePattern = beanNamePattern.substring(1);
                beanNamePattern = null;
            } else if (methodNameDelimiterIndex > 0) {
                methodNamePattern = beanNamePattern.substring(methodNameDelimiterIndex + 1);
                beanNamePattern = beanNamePattern.substring(0, methodNameDelimiterIndex);
            }
        }
        String beanIdPattern = null;
        String classNamePattern = null;
        if (beanNamePattern != null) {
            if (beanNamePattern.startsWith("class:")) {
                classNamePattern = beanNamePattern.substring("class:".length());
            } else {
                beanIdPattern = beanNamePattern;
            }
        }
        return new PointcutPattern(transletNamePattern, beanIdPattern, classNamePattern, methodNamePattern);
    }
}

