/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.AbstractPointcut;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.util.cache.Cache;
import com.aspectran.core.util.cache.ConcurrentReferenceCache;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpPointcut
extends AbstractPointcut {
    private final Cache<String, Pattern> cache = new ConcurrentReferenceCache<String, Pattern>(Pattern::compile);

    public RegexpPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        super(pointcutPatternRuleList);
    }

    @Override
    public boolean patternMatches(String regex, String compareString) {
        if (regex == null) {
            throw new IllegalArgumentException("regex must not be null");
        }
        Pattern pattern = this.cache.get(regex);
        Matcher matcher = pattern.matcher(compareString);
        return matcher.matches();
    }

    @Override
    public boolean patternMatches(String regex, String compareString, char separator) {
        return this.patternMatches(regex, compareString);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

