/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.component.bean.AbstractBeanFactory;
import com.aspectran.core.component.bean.BeanCreationException;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.UnsupportedBeanScopeException;
import com.aspectran.core.component.bean.scope.RequestScope;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.core.component.bean.scope.SingletonScope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.BeanProxifierType;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.lang.NonNull;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;

abstract class AbstractBeanRegistry
extends AbstractBeanFactory
implements BeanRegistry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeanRegistry.class);
    private final SingletonScope singletonScope = new SingletonScope();
    private final BeanRuleRegistry beanRuleRegistry;

    AbstractBeanRegistry(ActivityContext context, BeanRuleRegistry beanRuleRegistry, BeanProxifierType beanProxifierType) {
        super(context, beanProxifierType);
        this.beanRuleRegistry = beanRuleRegistry;
    }

    protected BeanRuleRegistry getBeanRuleRegistry() {
        return this.beanRuleRegistry;
    }

    protected <V> V getBean(BeanRule beanRule) {
        if (beanRule.getScopeType() == ScopeType.SINGLETON) {
            return (V)this.getSingletonScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.PROTOTYPE) {
            return this.getPrototypeScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.REQUEST) {
            return (V)this.getRequestScopeBean(beanRule);
        }
        if (beanRule.getScopeType() == ScopeType.SESSION) {
            return (V)this.getSessionScopeBean(beanRule);
        }
        throw new BeanCreationException(beanRule);
    }

    private Object getSingletonScopeBean(BeanRule beanRule) {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        return this.getScopedBean(this.singletonScope, beanRule);
    }

    @Override
    public <V> V getPrototypeScopeBean(BeanRule beanRule) {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        Object bean = this.createBean(beanRule);
        if (bean != null && beanRule.isFactoryProductionRequired()) {
            bean = this.getFactoryProducedObject(beanRule, bean);
        }
        return (V)bean;
    }

    private Object getRequestScopeBean(BeanRule beanRule) {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        RequestScope scope = this.getRequestScope();
        if (scope == null) {
            throw new UnsupportedBeanScopeException(ScopeType.REQUEST, beanRule);
        }
        return this.getScopedBean(scope, beanRule);
    }

    private Object getSessionScopeBean(BeanRule beanRule) {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        SessionScope scope = this.getSessionScope();
        if (scope == null) {
            throw new UnsupportedBeanScopeException(ScopeType.SESSION, beanRule);
        }
        return this.getScopedBean(scope, beanRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getScopedBean(Scope scope, BeanRule beanRule) {
        Object bean;
        block14: {
            ReadWriteLock scopeLock = scope.getScopeLock();
            if (scopeLock == null) {
                BeanInstance instance = scope.getBeanInstance(beanRule);
                Object bean2 = instance == null ? this.createBean(beanRule, scope) : instance.getBean();
                if (bean2 != null && beanRule.isFactoryProductionRequired()) {
                    bean2 = this.getFactoryProducedObject(beanRule, bean2);
                }
                return bean2;
            }
            boolean readLocked = true;
            scopeLock.readLock().lock();
            try {
                BeanInstance instance = scope.getBeanInstance(beanRule);
                if (instance == null) {
                    readLocked = false;
                    scopeLock.readLock().unlock();
                    scopeLock.writeLock().lock();
                    try {
                        instance = scope.getBeanInstance(beanRule);
                        bean = instance == null ? this.createBean(beanRule, scope) : instance.getBean();
                        if (bean != null && beanRule.isFactoryProductionRequired()) {
                            bean = this.getFactoryProducedObject(beanRule, bean);
                        }
                        break block14;
                    }
                    finally {
                        scopeLock.writeLock().unlock();
                    }
                }
                bean = instance.getBean();
                if (bean == null || !beanRule.isFactoryProductionRequired()) break block14;
                readLocked = false;
                scopeLock.readLock().unlock();
                scopeLock.writeLock().lock();
                try {
                    bean = this.getFactoryProducedObject(beanRule, bean);
                }
                finally {
                    scopeLock.writeLock().unlock();
                }
            }
            finally {
                if (readLocked) {
                    scopeLock.readLock().unlock();
                }
            }
        }
        return bean;
    }

    private RequestScope getRequestScope() {
        RequestAdapter requestAdapter;
        Activity activity = this.getActivityContext().getAvailableActivity();
        if (activity != null && (requestAdapter = activity.getRequestAdapter()) != null) {
            return requestAdapter.getRequestScope(true);
        }
        return null;
    }

    private SessionScope getSessionScope() {
        Activity activity = this.getActivityContext().getAvailableActivity();
        if (activity != null) {
            return SessionScope.restore(activity, this.getBeanRuleRegistry());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSingleton(Object bean) {
        ReadWriteLock scopeLock = this.singletonScope.getScopeLock();
        scopeLock.readLock().lock();
        try {
            boolean bl = this.singletonScope.getBeanRule(bean) != null;
            return bl;
        }
        finally {
            scopeLock.readLock().unlock();
        }
    }

    @Override
    public boolean hasSingleton(@NonNull Class<?> type) {
        return this.hasSingleton(type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSingleton(@NonNull Class<?> type, @Nullable String id) {
        ReadWriteLock scopeLock = this.singletonScope.getScopeLock();
        scopeLock.readLock().lock();
        try {
            BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
            if (beanRules == null) {
                BeanRule beanRule = this.getBeanRuleRegistry().getBeanRuleForConfig(type);
                if (beanRule != null) {
                    boolean bl = this.singletonScope.containsBeanRule(beanRule);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (beanRules.length == 1) {
                if (id != null) {
                    if (id.equals(beanRules[0].getId())) {
                        boolean bl = this.singletonScope.containsBeanRule(beanRules[0]);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.singletonScope.containsBeanRule(beanRules[0]);
                return bl;
            }
            if (id != null) {
                for (BeanRule beanRule : beanRules) {
                    if (!id.equals(beanRule.getId())) continue;
                    boolean bl = this.singletonScope.containsBeanRule(beanRule);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            for (BeanRule beanRule : beanRules) {
                if (!this.singletonScope.containsBeanRule(beanRule)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            scopeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySingleton(Object bean) throws Exception {
        block7: {
            ReadWriteLock scopeLock = this.singletonScope.getScopeLock();
            boolean readLocked = true;
            scopeLock.readLock().lock();
            try {
                BeanRule beanRule = this.singletonScope.getBeanRule(bean);
                if (beanRule == null) break block7;
                readLocked = false;
                scopeLock.readLock().unlock();
                scopeLock.writeLock().lock();
                try {
                    this.singletonScope.destroy(bean);
                }
                finally {
                    scopeLock.writeLock().unlock();
                }
            }
            finally {
                if (readLocked) {
                    scopeLock.readLock().unlock();
                }
            }
        }
    }

    private void instantiateSingletons() {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing singletons in " + this);
        }
        for (BeanRule beanRule : this.beanRuleRegistry.getIdBasedBeanRules()) {
            this.instantiateSingleton(beanRule);
        }
        for (Set set : this.beanRuleRegistry.getTypeBasedBeanRules()) {
            for (BeanRule beanRule : set) {
                this.instantiateSingleton(beanRule);
            }
        }
        for (BeanRule beanRule : this.beanRuleRegistry.getConfigurableBeanRules()) {
            this.instantiateSingleton(beanRule);
        }
    }

    private void instantiateSingleton(BeanRule beanRule) {
        if (beanRule.isSingleton() && !beanRule.isLazyInit() && !this.singletonScope.containsBeanRule(beanRule)) {
            this.createBean(beanRule, this.singletonScope);
        }
    }

    private void destroySingletons() {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying singletons in " + this);
        }
        this.singletonScope.destroy();
    }

    @Override
    protected void doInitialize() throws Exception {
        this.instantiateSingletons();
    }

    @Override
    protected void doDestroy() throws Exception {
        this.destroySingletons();
    }
}

