/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scope;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.scope.AbstractScope;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionBindingListener;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionScope
extends AbstractScope
implements SessionBindingListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionScope.class);
    private static final String SESSION_SCOPE_ATTR_NAME = SessionScope.class.getName();
    private static final String SESSION_SCOPED_BEAN_INSTANCES_ATTR_NAME = SessionScope.class.getName() + ".BEAN_INSTANCES";
    private static final ScopeType scopeType = ScopeType.SESSION;
    private final ReadWriteLock scopeLock = new ReentrantReadWriteLock();
    private final Map<String, BeanInstance> sessionScopedBeanInstances = new HashMap<String, BeanInstance>();

    @Override
    public ScopeType getScopeType() {
        return scopeType;
    }

    @Override
    public ReadWriteLock getScopeLock() {
        return this.scopeLock;
    }

    @Override
    public void valueUnbound(Session session, String name, Object value) {
        this.destroy();
    }

    @Override
    public void putBeanInstance(Activity activity, BeanRule beanRule, BeanInstance beanInstance) {
        super.putBeanInstance(activity, beanRule, beanInstance);
        if (beanRule.getId() != null) {
            this.sessionScopedBeanInstances.put(beanRule.getId(), beanInstance);
        } else {
            String name = "class:" + beanRule.getTargetBeanClassName();
            this.sessionScopedBeanInstances.put(name, beanInstance);
        }
        SessionAdapter sessionAdapter = activity.getSessionAdapter();
        if (sessionAdapter != null) {
            SessionScope.putSessionScopedBeanInstances(sessionAdapter, this.sessionScopedBeanInstances);
        }
    }

    private Map<String, BeanInstance> getSessionScopedBeanInstances() {
        return this.sessionScopedBeanInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionScope restore(Activity activity, BeanRuleRegistry beanRuleRegistry) {
        SessionAdapter sessionAdapter = activity.getSessionAdapter();
        if (sessionAdapter == null) {
            return null;
        }
        SessionScope sessionScope = SessionScope.getSessionScope(sessionAdapter);
        if (sessionScope == null) {
            sessionScope = sessionAdapter.newSessionScope();
            ReadWriteLock scopeLock = sessionScope.getScopeLock();
            scopeLock.writeLock().lock();
            try {
                SessionScope.putSessionScope(sessionAdapter, sessionScope);
                Map<String, BeanInstance> map = SessionScope.getSessionScopedBeanInstances(sessionAdapter);
                if (map != null) {
                    for (Map.Entry<String, BeanInstance> entry : map.entrySet()) {
                        String beanName = entry.getKey();
                        BeanInstance beanInstance = entry.getValue();
                        if (beanInstance == null) continue;
                        try {
                            BeanRule[] beanRules = beanRuleRegistry.getBeanRules(beanName);
                            if (beanRules == null) {
                                logger.warn("No bean named '" + beanName + "' available");
                                continue;
                            }
                            if (beanRules.length > 1) {
                                logger.warn("No qualifying bean of type '" + beanName + "' is defined: expected single matching bean but found " + beanRules.length + ": [" + NoUniqueBeanException.getBeanDescriptions(beanRules) + "]");
                                continue;
                            }
                            sessionScope.putBeanInstance(activity, beanRules[0], beanInstance);
                        }
                        catch (Exception e) {
                            logger.warn("Failed to restore the bean to session scope", e);
                        }
                    }
                } else {
                    Map<String, BeanInstance> sessionScopedBeanInstances = sessionScope.getSessionScopedBeanInstances();
                    sessionAdapter.setAttribute(SESSION_SCOPED_BEAN_INSTANCES_ATTR_NAME, sessionScopedBeanInstances);
                }
            }
            finally {
                scopeLock.writeLock().unlock();
            }
        }
        return sessionScope;
    }

    private static SessionScope getSessionScope(SessionAdapter sessionAdapter) {
        return (SessionScope)sessionAdapter.getAttribute(SESSION_SCOPE_ATTR_NAME);
    }

    private static void putSessionScope(SessionAdapter sessionAdapter, SessionScope sessionScope) {
        sessionAdapter.setAttribute(SESSION_SCOPE_ATTR_NAME, sessionScope);
    }

    private static Map<String, BeanInstance> getSessionScopedBeanInstances(SessionAdapter sessionAdapter) {
        return (Map)sessionAdapter.getAttribute(SESSION_SCOPED_BEAN_INSTANCES_ATTR_NAME);
    }

    private static void putSessionScopedBeanInstances(SessionAdapter sessionAdapter, Map<String, BeanInstance> map) {
        sessionAdapter.setAttribute(SESSION_SCOPED_BEAN_INSTANCES_ATTR_NAME, map);
    }
}

