/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSessionStore
extends AbstractComponent
implements SessionStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionStore.class);
    private int gracePeriodSecs = 3600;
    private long lastExpiryCheckTime = 0L;
    private int savePeriodSecs = 0;
    private Set<String> nonPersistentAttributes;

    public int getGracePeriodSecs() {
        return this.gracePeriodSecs;
    }

    public void setGracePeriodSecs(int gracePeriodSecs) {
        this.gracePeriodSecs = gracePeriodSecs;
    }

    public int getSavePeriodSecs() {
        return this.savePeriodSecs;
    }

    public void setSavePeriodSecs(int savePeriodSecs) {
        this.savePeriodSecs = savePeriodSecs;
    }

    @Override
    public Set<String> getNonPersistentAttributes() {
        return this.nonPersistentAttributes;
    }

    public void setNonPersistentAttributes(String ... nonPersistentAttributes) {
        if (nonPersistentAttributes != null && nonPersistentAttributes.length > 0) {
            HashSet attrNames = new HashSet();
            Collections.addAll(attrNames, nonPersistentAttributes);
            this.nonPersistentAttributes = Collections.unmodifiableSet(attrNames);
        } else {
            this.nonPersistentAttributes = null;
        }
    }

    public boolean isNonPersistentAttributes(String attrName) {
        if (this.nonPersistentAttributes != null) {
            return this.nonPersistentAttributes.contains(attrName);
        }
        return false;
    }

    @Override
    public void save(String id, SessionData data) throws Exception {
        long savePeriodMs;
        if (data == null) {
            return;
        }
        long lastSaveMs = data.getLastSaved();
        long l = savePeriodMs = this.savePeriodSecs <= 0 ? 0L : TimeUnit.SECONDS.toMillis(this.savePeriodSecs);
        if (logger.isTraceEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Store session");
            tsb.append("id", id);
            tsb.append("dirty", data.isDirty());
            tsb.append("lastSaved", data.getLastSaved());
            tsb.append("savePeriod", savePeriodMs);
            tsb.append("elapsed", System.currentTimeMillis() - lastSaveMs);
            logger.trace(tsb.toString());
        }
        if (data.isDirty() || lastSaveMs <= 0L || System.currentTimeMillis() - lastSaveMs > savePeriodMs) {
            data.setLastSaved(System.currentTimeMillis());
            try {
                this.doSave(id, data);
                data.setDirty(false);
            }
            catch (Exception e) {
                data.setLastSaved(lastSaveMs);
                throw e;
            }
        }
    }

    public abstract void doSave(String var1, SessionData var2) throws Exception;

    @Override
    public Set<String> getExpired(Set<String> candidates) {
        try {
            Set<String> set = this.doGetExpired(candidates);
            return set;
        }
        finally {
            this.lastExpiryCheckTime = System.currentTimeMillis();
        }
    }

    public abstract Set<String> doGetExpired(Set<String> var1);

    public long getLastExpiryCheckTime() {
        return this.lastExpiryCheckTime;
    }

    protected void checkAlreadyInitialized() throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
    }
}

