/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionCache;
import com.aspectran.core.component.session.DefaultSession;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.statistic.CounterStatistic;
import com.aspectran.core.util.thread.AutoLock;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionCache.class);
    private final Map<String, DefaultSession> sessions = new ConcurrentHashMap<String, DefaultSession>();
    private final CounterStatistic statistics = new CounterStatistic();
    private final AtomicLong expiredSessionCount = new AtomicLong();
    private final AtomicLong rejectedSessionCount = new AtomicLong();
    private volatile int maxSessions;

    public DefaultSessionCache(SessionHandler sessionHandler, SessionStore sessionStore, boolean clusterEnabled) {
        super(sessionHandler, sessionStore, clusterEnabled);
    }

    @Override
    public int getMaxSessions() {
        return this.maxSessions;
    }

    @Override
    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    @Override
    protected DefaultSession doGet(String id) {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    protected DefaultSession doPutIfAbsent(String id, DefaultSession session) {
        DefaultSession ds = this.sessions.putIfAbsent(id, session);
        if (ds == null) {
            this.checkMaxSessions(id);
        }
        return ds;
    }

    @Override
    protected DefaultSession doComputeIfAbsent(String id, Function<String, DefaultSession> mappingFunction) {
        return this.sessions.computeIfAbsent(id, k -> {
            DefaultSession ds = (DefaultSession)mappingFunction.apply((String)k);
            if (ds != null) {
                this.checkMaxSessions(null);
            }
            return ds;
        });
    }

    @Override
    protected DefaultSession doDelete(String id) {
        DefaultSession ds = this.sessions.remove(id);
        if (ds != null) {
            this.statistics.decrement();
            this.expiredSessionCount.incrementAndGet();
        }
        return ds;
    }

    @Override
    protected boolean doReplace(String id, DefaultSession oldValue, DefaultSession newValue) {
        return this.sessions.replace(id, oldValue, newValue);
    }

    private void checkMaxSessions(String id) {
        if (this.maxSessions > 0 && this.statistics.getCurrent() >= (long)this.maxSessions) {
            if (id != null) {
                this.sessions.remove(id);
            }
            this.rejectedSessionCount.incrementAndGet();
            throw new IllegalStateException("Session was rejected as the maximum number of sessions " + this.maxSessions + " has been hit");
        }
        this.statistics.increment();
    }

    @Override
    public Set<String> getAllSessions() {
        return this.sessions.keySet();
    }

    @Override
    public long getActiveSessionCount() {
        return this.statistics.getCurrent();
    }

    @Override
    public long getHighestSessionCount() {
        return this.statistics.getMax();
    }

    @Override
    public long getCreatedSessionCount() {
        return this.statistics.getTotal();
    }

    @Override
    public long getExpiredSessionCount() {
        return this.expiredSessionCount.get();
    }

    @Override
    public long getRejectedSessionCount() {
        return this.rejectedSessionCount.get();
    }

    @Override
    public void resetStatistics() {
        this.statistics.reset();
        this.expiredSessionCount.set(0L);
        this.rejectedSessionCount.set(0L);
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.getSessionStore() != null) {
            this.getSessionStore().initialize();
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        int loop = 100;
        while (!this.sessions.isEmpty() && loop-- >= 0) {
            for (DefaultSession session : this.sessions.values()) {
                if (this.getSessionStore() != null) {
                    if (this.getSessionStore().getNonPersistentAttributes() != null) {
                        for (String name : this.getSessionStore().getNonPersistentAttributes()) {
                            try {
                                Object old;
                                try (AutoLock ignored = session.lock();){
                                    old = session.getSessionData().setAttribute(name, null);
                                }
                                if (old == null) continue;
                                session.fireSessionAttributeListeners(name, old, null);
                            }
                            catch (Exception e) {
                                logger.warn("Failed to remove non-persistent attribute: " + name, e);
                            }
                        }
                    }
                    try {
                        this.getSessionStore().save(session.getId(), session.getSessionData());
                    }
                    catch (Exception e) {
                        logger.warn("Failed to save session data of session id=" + session.getId(), e);
                    }
                    this.doDelete(session.getId());
                    continue;
                }
                try {
                    session.invalidate();
                    session.setDestroyedReason(Session.DestroyedReason.UNDEPLOY);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Session invalidation failed, but ignored", e);
                }
            }
        }
        if (this.getSessionStore() != null) {
            this.getSessionStore().destroy();
        }
    }
}

