/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.NonPersistent;
import com.aspectran.core.util.CustomObjectInputStream;
import com.aspectran.core.util.ToStringBuilder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = -6253355753257200708L;
    private String id;
    private final long created;
    private long accessed;
    private long lastAccessed;
    private long inactiveInterval;
    private long expiry;
    private boolean dirty;
    private long lastSaved;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public SessionData(String id, long created, long accessed, long lastAccessed, long inactiveInterval) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
        this.created = created;
        this.accessed = accessed;
        this.lastAccessed = lastAccessed;
        this.inactiveInterval = inactiveInterval;
        this.calcAndSetExpiry(created);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreated() {
        return this.created;
    }

    public long getAccessed() {
        return this.accessed;
    }

    public void setAccessed(long accessed) {
        this.accessed = accessed;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public long getInactiveInterval() {
        return this.inactiveInterval;
    }

    public void setInactiveInterval(long inactiveInterval) {
        this.inactiveInterval = inactiveInterval;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public long calcExpiry() {
        return this.calcExpiry(System.currentTimeMillis());
    }

    public long calcExpiry(long time) {
        return this.inactiveInterval <= 0L ? 0L : time + this.inactiveInterval;
    }

    public void calcAndSetExpiry() {
        this.setExpiry(this.calcExpiry());
    }

    public void calcAndSetExpiry(long time) {
        this.setExpiry(this.calcExpiry(time));
    }

    public boolean isExpiredAt(long time) {
        if (this.inactiveInterval <= 0L) {
            return false;
        }
        return this.expiry <= time;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getLastSaved() {
        return this.lastSaved;
    }

    public void setLastSaved(long lastSaved) {
        this.lastSaved = lastSaved;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public <T> T setAttribute(String name, Object value) {
        Object old = value == null ? this.attributes.remove(name) : this.attributes.put(name, value);
        if (value == null && old == null) {
            return null;
        }
        this.setDirty(true);
        return (T)old;
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public Map<String, Object> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void putAllAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public void clearAllAttributes() {
        this.attributes.clear();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.getId());
        tsb.append("created", this.getCreated());
        tsb.append("accessed", this.getLastAccessed());
        tsb.append("lastAccessed", this.getLastAccessed());
        tsb.append("maxInactiveInterval", this.getInactiveInterval());
        tsb.append("expiry", this.getExpiry());
        return tsb.toString();
    }

    public static void serialize(SessionData data, OutputStream os, Set<String> nonPersistentAttributes) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF(data.getId());
        out.writeLong(data.getCreated());
        out.writeLong(data.getAccessed());
        out.writeLong(data.getLastAccessed());
        out.writeLong(data.getExpiry());
        out.writeLong(data.getInactiveInterval());
        Set<String> keys = data.getKeys();
        if (keys.isEmpty()) {
            out.writeInt(0);
            return;
        }
        ArrayList<String> attrKeys = new ArrayList<String>(keys);
        if (nonPersistentAttributes != null && !attrKeys.isEmpty()) {
            attrKeys.removeAll(nonPersistentAttributes);
        }
        for (String name : attrKeys) {
            Object value = data.getAttribute(name);
            if (!(value instanceof NonPersistent)) continue;
            attrKeys.remove(name);
        }
        out.writeInt(attrKeys.size());
        if (!attrKeys.isEmpty()) {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            for (String name : attrKeys) {
                Object value = data.getAttribute(name);
                oos.writeUTF(name);
                oos.writeObject(value);
            }
        }
    }

    public static SessionData deserialize(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        String id = dis.readUTF();
        long created = dis.readLong();
        long accessed = dis.readLong();
        long lastAccessed = dis.readLong();
        long expiry = dis.readLong();
        long maxInactive = dis.readLong();
        int entries = dis.readInt();
        SessionData data = new SessionData(id, created, accessed, lastAccessed, maxInactive);
        data.setExpiry(expiry);
        data.setInactiveInterval(maxInactive);
        SessionData.restoreAttributes(dis, entries, data);
        return data;
    }

    private static void restoreAttributes(InputStream is, int entries, SessionData data) throws Exception {
        if (entries > 0) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CustomObjectInputStream ois = new CustomObjectInputStream(is);
            for (int i = 0; i < entries; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                attributes.put(key, value);
            }
            data.putAllAttributes(attributes);
        }
    }
}

